/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.util;

import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class StringMap<O>
extends AbstractMap<String, O> {
    private final TreeMap<Object, O> _map;
    public static final boolean CASE_INSENSTIVE = true;
    private final boolean _caseInsensitive;

    public StringMap() {
        this(false);
    }

    public StringMap(final boolean ignoreCase) {
        this._caseInsensitive = ignoreCase;
        this._map = new TreeMap(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                ByteBuffer b1;
                String s1 = o1 instanceof String ? (String)o1 : null;
                ByteBuffer byteBuffer = b1 = o1 instanceof ByteBuffer ? (ByteBuffer)o1 : null;
                if (s1 == null && b1 == null) {
                    s1 = o1.toString();
                }
                String s2 = (String)o2;
                int n1 = s1 == null ? b1.remaining() : s1.length();
                int n2 = s2.length();
                int min = Math.min(n1, n2);
                for (int i = 0; i < min; ++i) {
                    char c2;
                    char c1 = s1 == null ? (char)b1.get(b1.position() + i) : s1.charAt(i);
                    if (c1 == (c2 = s2.charAt(i))) continue;
                    if (ignoreCase) {
                        if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
                        return c1 - c2;
                    }
                    return c1 - c2;
                }
                return n1 - n2;
            }
        });
    }

    public boolean isIgnoreCase() {
        return this._caseInsensitive;
    }

    @Override
    public O put(String key, O value) {
        return this._map.put(key, value);
    }

    @Override
    public O get(Object key) {
        return this._map.get(key);
    }

    public O get(String key) {
        return this._map.get(key);
    }

    public O get(String key, int offset, int length) {
        return this._map.get(key.substring(offset, offset + length));
    }

    public O get(ByteBuffer buffer) {
        return this._map.get(buffer);
    }

    @Override
    public O remove(Object key) {
        return this._map.remove(key);
    }

    public O remove(String key) {
        return this._map.remove(key);
    }

    @Override
    public Set<Map.Entry<String, O>> entrySet() {
        Set<Map.Entry<Object, O>> o = this._map.entrySet();
        return Collections.unmodifiableSet(o);
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    @Override
    public void clear() {
        this._map.clear();
    }
}

