/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client;

import com.facebook.presto.jdbc.internal.airlift.http.client.BodyGenerator;
import com.facebook.presto.jdbc.internal.guava.annotations.Beta;
import com.facebook.presto.jdbc.internal.guava.base.Objects;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.collect.ArrayListMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableListMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.ListMultimap;
import java.net.URI;
import java.util.List;
import java.util.Map;

@Beta
public class Request {
    private final URI uri;
    private final String method;
    private final ListMultimap<String, String> headers;
    private final BodyGenerator bodyGenerator;

    public Request(URI uri, String method, ListMultimap<String, String> headers, BodyGenerator bodyGenerator) {
        Preconditions.checkNotNull(uri, "uri is null");
        Preconditions.checkNotNull(uri.getHost(), "uri does not have a host: %s", uri);
        Preconditions.checkNotNull(method, "method is null");
        Preconditions.checkNotNull(uri.getScheme(), "uri does not have a scheme: %s", uri);
        String scheme = uri.getScheme().toLowerCase();
        Preconditions.checkArgument(!"http".equals(scheme) || !"https".equals(scheme), "uri scheme must be http or https: %s", uri);
        this.uri = Request.validateUri(uri);
        this.method = method;
        this.headers = ImmutableListMultimap.copyOf(headers);
        this.bodyGenerator = bodyGenerator;
    }

    public static Builder builder() {
        return new Builder();
    }

    public URI getUri() {
        return this.uri;
    }

    public String getMethod() {
        return this.method;
    }

    public String getHeader(String name) {
        List<String> values = this.headers.get(name);
        if (values != null && !values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    public ListMultimap<String, String> getHeaders() {
        return this.headers;
    }

    public BodyGenerator getBodyGenerator() {
        return this.bodyGenerator;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("uri", this.uri).add("method", this.method).add("headers", this.headers).add("bodyGenerator", this.bodyGenerator).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Request)) {
            return false;
        }
        Request r = (Request)o;
        return Objects.equal(this.uri, r.uri) && Objects.equal(this.method, r.method) && Objects.equal(this.headers, r.headers) && Objects.equal(this.bodyGenerator, r.bodyGenerator);
    }

    public int hashCode() {
        return Objects.hashCode(this.uri, this.method, this.headers, this.bodyGenerator);
    }

    private static URI validateUri(URI uri) {
        Preconditions.checkArgument(uri.getPort() != 0, "Cannot make requests to HTTP port 0");
        return uri;
    }

    @Beta
    public static class Builder {
        private URI uri;
        private String method;
        private final ListMultimap<String, String> headers = ArrayListMultimap.create();
        private BodyGenerator bodyGenerator;

        public static Builder prepareHead() {
            return new Builder().setMethod("HEAD");
        }

        public static Builder prepareGet() {
            return new Builder().setMethod("GET");
        }

        public static Builder preparePost() {
            return new Builder().setMethod("POST");
        }

        public static Builder preparePut() {
            return new Builder().setMethod("PUT");
        }

        public static Builder prepareDelete() {
            return new Builder().setMethod("DELETE");
        }

        public static Builder fromRequest(Request request) {
            Builder requestBuilder = new Builder();
            requestBuilder.setMethod(request.getMethod());
            requestBuilder.setBodyGenerator(request.getBodyGenerator());
            requestBuilder.setUri(request.getUri());
            for (Map.Entry entry : request.getHeaders().entries()) {
                requestBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
            return requestBuilder;
        }

        public Builder setUri(URI uri) {
            this.uri = Request.validateUri(uri);
            return this;
        }

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder setHeader(String name, String value) {
            this.headers.removeAll(name);
            this.headers.put(name, value);
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public Builder setBodyGenerator(BodyGenerator bodyGenerator) {
            this.bodyGenerator = bodyGenerator;
            return this;
        }

        public Request build() {
            return new Request(this.uri, this.method, this.headers, this.bodyGenerator);
        }
    }
}

