/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.stats.cardinality;

import com.facebook.presto.jdbc.internal.airlift.slice.BasicSliceInput;
import com.facebook.presto.jdbc.internal.airlift.slice.DynamicSliceOutput;
import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.stats.cardinality.DenseHll;
import com.facebook.presto.jdbc.internal.airlift.stats.cardinality.Format;
import com.facebook.presto.jdbc.internal.airlift.stats.cardinality.HllInstance;
import com.facebook.presto.jdbc.internal.airlift.stats.cardinality.Utils;
import com.facebook.presto.jdbc.internal.guava.annotations.VisibleForTesting;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.collect.Ordering;
import com.facebook.presto.jdbc.internal.guava.primitives.Ints;
import com.facebook.presto.jdbc.internal.guava.primitives.Shorts;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class SparseHll
implements HllInstance {
    private static final int SPARSE_INSTANCE_SIZE = ClassLayout.parseClass(SparseHll.class).instanceSize();
    private final byte indexBitLength;
    private short numberOfHashes;
    private short[] shortHashes;
    private short numberOfOverflows;
    private short[] overflows;

    public SparseHll(int indexBitLength) {
        Preconditions.checkArgument(indexBitLength >= 1 && indexBitLength <= 13, "indexBitLength is out of range");
        this.indexBitLength = (byte)indexBitLength;
        this.shortHashes = new short[1];
        this.overflows = new short[0];
    }

    public SparseHll(Slice serialized) {
        int i;
        BasicSliceInput input = serialized.getInput();
        Preconditions.checkArgument(input.readByte() == Format.SPARSE_V1.getTag(), "invalid format tag");
        this.indexBitLength = input.readByte();
        Preconditions.checkArgument(this.indexBitLength >= 1 && this.indexBitLength <= 13, "indexBitLength is out of range");
        this.numberOfHashes = input.readShort();
        this.numberOfOverflows = input.readShort();
        this.shortHashes = new short[this.numberOfHashes];
        for (i = 0; i < this.numberOfHashes; ++i) {
            this.shortHashes[i] = input.readShort();
        }
        this.overflows = new short[this.numberOfOverflows];
        for (i = 0; i < this.numberOfOverflows; ++i) {
            this.overflows[i] = input.readShort();
        }
        Preconditions.checkArgument(!input.isReadable(), "input is too big");
    }

    public static boolean canDeserialize(Slice serialized) {
        return serialized.getByte(0) == Format.SPARSE_V1.getTag();
    }

    @Override
    public void insertHash(long hash) {
        this.insertShortHash(hash);
        this.insertOverflowEntryIfNeeded(hash);
    }

    private void insertOverflowEntryIfNeeded(long hash) {
        int overflowBits;
        int zeros = Utils.numberOfLeadingZeros(hash, this.indexBitLength);
        if (zeros > (overflowBits = 16 - this.indexBitLength)) {
            int overflowZeros = zeros - overflowBits - 1;
            int bucketIndex = Utils.computeIndex(hash, this.indexBitLength);
            short overflowEntry = (short)(bucketIndex << overflowBits | overflowZeros & SparseHll.valueMask(this.indexBitLength));
            int position = this.searchOverflow(bucketIndex);
            if (position < 0) {
                int insertionPoint;
                if (this.numberOfOverflows + 1 > this.overflows.length) {
                    this.overflows = Arrays.copyOf(this.overflows, this.overflows.length + 1);
                }
                if ((insertionPoint = -(position + 1)) < this.numberOfOverflows) {
                    System.arraycopy(this.overflows, insertionPoint, this.overflows, insertionPoint + 1, this.numberOfOverflows - insertionPoint);
                }
                this.overflows[insertionPoint] = overflowEntry;
                this.numberOfOverflows = (short)(this.numberOfOverflows + 1);
            } else {
                int oldValue = this.extractValue(this.overflows[position]);
                if (overflowZeros > oldValue) {
                    this.overflows[position] = overflowEntry;
                }
            }
        }
    }

    public void mergeWith(SparseHll other) {
        this.shortHashes = this.mergeShortHashes(other);
        this.numberOfHashes = (short)this.shortHashes.length;
        this.overflows = this.mergeOverflows(other);
        this.numberOfOverflows = (short)this.overflows.length;
    }

    @Override
    public DenseHll toDense() {
        DenseHll result = new DenseHll(this.indexBitLength);
        int overflowIndex = 0;
        for (int hashIndex = 0; hashIndex < this.numberOfHashes; ++hashIndex) {
            int valueBits;
            short shortHash = this.shortHashes[hashIndex];
            int bucket = SparseHll.extractIndex(this.indexBitLength, shortHash);
            int zeros = Utils.numberOfLeadingZeros(this.toLongHash(shortHash), this.indexBitLength);
            if (zeros > (valueBits = 16 - this.indexBitLength)) {
                short overflow;
                int overflowBucket;
                zeros = valueBits;
                while (overflowIndex < this.numberOfOverflows && (overflowBucket = SparseHll.extractIndex(this.indexBitLength, overflow = this.overflows[overflowIndex])) <= bucket) {
                    ++overflowIndex;
                    if (overflowBucket != bucket) continue;
                    zeros += this.extractValue(overflow) + 1;
                    break;
                }
            }
            result.insert(bucket, zeros + 1);
        }
        return result;
    }

    @Override
    public long cardinality() {
        int totalBuckets = Utils.numberOfBuckets(16);
        int zeroBuckets = totalBuckets - this.numberOfHashes;
        return Math.round(Utils.linearCounting(zeroBuckets, totalBuckets));
    }

    @Override
    public int estimatedInMemorySize() {
        return SPARSE_INSTANCE_SIZE + 2 * this.numberOfHashes + 2 * this.numberOfOverflows;
    }

    @Override
    public int getIndexBitLength() {
        return this.indexBitLength;
    }

    private void insertShortHash(long hash) {
        short shortHash = this.toShortHash(hash);
        int position = this.searchShortHash(shortHash);
        if (position < 0) {
            int insertionPoint;
            if (this.numberOfHashes + 1 > this.shortHashes.length) {
                this.shortHashes = Arrays.copyOf(this.shortHashes, this.shortHashes.length + 10);
            }
            if ((insertionPoint = -(position + 1)) < this.numberOfHashes) {
                System.arraycopy(this.shortHashes, insertionPoint, this.shortHashes, insertionPoint + 1, this.numberOfHashes - insertionPoint);
            }
            this.shortHashes[insertionPoint] = shortHash;
            this.numberOfHashes = (short)(this.numberOfHashes + 1);
        }
    }

    private int searchOverflow(int bucketIndex) {
        int low = 0;
        int high = this.numberOfOverflows - 1;
        while (low <= high) {
            int middle = low + high >>> 1;
            int middleBucketIndex = SparseHll.extractIndex(this.indexBitLength, this.overflows[middle]);
            if (bucketIndex > middleBucketIndex) {
                low = middle + 1;
                continue;
            }
            if (bucketIndex < middleBucketIndex) {
                high = middle - 1;
                continue;
            }
            return middle;
        }
        return -(low + 1);
    }

    private int searchShortHash(short value) {
        int unsignedValue = value & 0xFFFF;
        int low = 0;
        int high = this.numberOfHashes - 1;
        while (low <= high) {
            int middle = low + high >>> 1;
            int middleEntry = this.shortHashes[middle] & 0xFFFF;
            if (unsignedValue > middleEntry) {
                low = middle + 1;
                continue;
            }
            if (unsignedValue < middleEntry) {
                high = middle - 1;
                continue;
            }
            return middle;
        }
        return -(low + 1);
    }

    private short[] mergeOverflows(SparseHll other) {
        short[] result = new short[this.numberOfOverflows + other.numberOfOverflows];
        int left = 0;
        int right = 0;
        int index = 0;
        while (left < this.numberOfOverflows && right < other.numberOfOverflows) {
            int rightValue;
            int rightIndex;
            int leftIndex = SparseHll.extractIndex(this.indexBitLength, this.overflows[left]);
            if (leftIndex < (rightIndex = SparseHll.extractIndex(this.indexBitLength, other.overflows[right]))) {
                result[index++] = this.overflows[left++];
                continue;
            }
            if (leftIndex > rightIndex) {
                result[index++] = other.overflows[right++];
                continue;
            }
            int leftValue = this.extractValue(this.overflows[left]);
            result[index] = leftValue > (rightValue = this.extractValue(other.overflows[right])) ? this.overflows[left] : other.overflows[right];
            ++index;
            ++left;
            ++right;
        }
        while (left < this.numberOfOverflows) {
            result[index++] = this.overflows[left++];
        }
        while (right < other.numberOfOverflows) {
            result[index++] = other.overflows[right++];
        }
        return Arrays.copyOf(result, index);
    }

    private short[] mergeShortHashes(SparseHll other) {
        short[] result = new short[this.numberOfHashes + other.numberOfHashes];
        int leftIndex = 0;
        int rightIndex = 0;
        int index = 0;
        while (leftIndex < this.numberOfHashes && rightIndex < other.numberOfHashes) {
            int left = this.shortHashes[leftIndex] & 0xFFFF;
            int right = other.shortHashes[rightIndex] & 0xFFFF;
            if (left < right) {
                result[index++] = this.shortHashes[leftIndex++];
                continue;
            }
            if (left > right) {
                result[index++] = other.shortHashes[rightIndex++];
                continue;
            }
            result[index++] = this.shortHashes[leftIndex];
            ++leftIndex;
            ++rightIndex;
        }
        while (leftIndex < this.numberOfHashes) {
            result[index++] = this.shortHashes[leftIndex++];
        }
        while (rightIndex < other.numberOfHashes) {
            result[index++] = other.shortHashes[rightIndex++];
        }
        return Arrays.copyOf(result, index);
    }

    private short toShortHash(long hash) {
        return (short)(hash >>> 48);
    }

    private long toLongHash(short shortHash) {
        return (long)shortHash << 48;
    }

    private static int extractIndex(int indexBitLength, short entry) {
        return (entry & 0xFFFF) >>> 16 - indexBitLength;
    }

    private int extractValue(short entry) {
        return entry & SparseHll.valueMask(this.indexBitLength);
    }

    private static int valueMask(int indexBitLength) {
        return (1 << 16 - indexBitLength) - 1;
    }

    @Override
    public Slice serialize() {
        int i;
        int size = 6 + 2 * this.numberOfHashes + 2 * this.numberOfOverflows;
        DynamicSliceOutput out = new DynamicSliceOutput(size).appendByte(Format.SPARSE_V1.getTag()).appendByte(this.indexBitLength).appendShort(this.numberOfHashes).appendShort(this.numberOfOverflows);
        for (i = 0; i < this.numberOfHashes; ++i) {
            out.appendShort(this.shortHashes[i]);
        }
        for (i = 0; i < this.numberOfOverflows; ++i) {
            out.appendShort(this.overflows[i]);
        }
        return out.slice();
    }

    @Override
    public int estimatedSerializedSize() {
        return 7 + this.numberOfHashes * 2 + this.numberOfOverflows * 2;
    }

    @Override
    @VisibleForTesting
    public void verify() {
        Preconditions.checkState(this.numberOfHashes <= this.shortHashes.length, "Expected number of hashes (%s) larger than array length (%s)", this.numberOfHashes, this.shortHashes.length);
        Preconditions.checkState(this.numberOfOverflows <= this.overflows.length, "Expected number of overflows (%s) larger than array length (%s)", this.numberOfOverflows, this.overflows.length);
        Comparator<Short> hashComparator = new Comparator<Short>(){

            @Override
            public int compare(Short o1, Short o2) {
                return Ints.compare(o1.intValue() & 0xFFFF, o2.intValue() & 0xFFFF);
            }
        };
        Preconditions.checkState(Ordering.from(hashComparator).isOrdered(Shorts.asList(Arrays.copyOf(this.shortHashes, (int)this.numberOfHashes))), "hashes are not sorted");
        Comparator<Short> overflowComparator = new Comparator<Short>(){

            @Override
            public int compare(Short o1, Short o2) {
                return Ints.compare(SparseHll.extractIndex(SparseHll.this.indexBitLength, o1), SparseHll.extractIndex(SparseHll.this.indexBitLength, o2));
            }
        };
        Preconditions.checkState(Ordering.from(overflowComparator).isOrdered(Shorts.asList(Arrays.copyOf(this.overflows, (int)this.numberOfOverflows))), "overflows are not sorted");
    }
}

