/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client;

import com.facebook.presto.jdbc.internal.jetty.client.ConnectionPool;
import com.facebook.presto.jdbc.internal.jetty.client.HttpClient;
import com.facebook.presto.jdbc.internal.jetty.client.HttpDestination;
import com.facebook.presto.jdbc.internal.jetty.client.HttpExchange;
import com.facebook.presto.jdbc.internal.jetty.client.Origin;
import com.facebook.presto.jdbc.internal.jetty.client.api.Connection;
import com.facebook.presto.jdbc.internal.jetty.client.api.Request;
import com.facebook.presto.jdbc.internal.jetty.util.Promise;
import com.facebook.presto.jdbc.internal.jetty.util.component.ContainerLifeCycle;
import java.io.IOException;
import java.util.Arrays;

public abstract class PoolingHttpDestination<C extends Connection>
extends HttpDestination
implements Promise<Connection> {
    private final ConnectionPool connectionPool;

    public PoolingHttpDestination(HttpClient client, Origin origin) {
        super(client, origin);
        this.connectionPool = this.newConnectionPool(client);
    }

    protected ConnectionPool newConnectionPool(HttpClient client) {
        return new ConnectionPool(this, client.getMaxConnectionsPerDestination(), this);
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    @Override
    public void succeeded(Connection connection) {
        this.process(connection, true);
    }

    @Override
    public void failed(final Throwable x) {
        this.getHttpClient().getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                PoolingHttpDestination.this.abort(x);
            }
        });
    }

    @Override
    protected void send() {
        C connection = this.acquire();
        if (connection != null) {
            this.process(connection, false);
        }
    }

    public C acquire() {
        return (C)this.connectionPool.acquire();
    }

    public void process(C connection, boolean dispatch) {
        HttpClient client = this.getHttpClient();
        HttpExchange exchange = this.getHttpExchanges().poll();
        LOG.debug("Processing exchange {} on connection {}", exchange, connection);
        if (exchange == null) {
            if (!this.connectionPool.release((Connection)connection)) {
                connection.close();
            }
            if (!client.isRunning()) {
                LOG.debug("{} is stopping", client);
                connection.close();
            }
        } else {
            Request request = exchange.getRequest();
            Throwable cause = request.getAbortCause();
            if (cause != null) {
                LOG.debug("Aborted before processing {}: {}", exchange, cause);
                exchange.abort(cause);
            } else if (dispatch) {
                client.getExecutor().execute(new Runnable((Connection)connection, exchange){
                    final /* synthetic */ Connection val$connection;
                    final /* synthetic */ HttpExchange val$exchange;
                    {
                        this.val$connection = connection;
                        this.val$exchange = httpExchange;
                    }

                    @Override
                    public void run() {
                        PoolingHttpDestination.this.send(this.val$connection, this.val$exchange);
                    }
                });
            } else {
                this.send(connection, exchange);
            }
        }
    }

    protected abstract void send(C var1, HttpExchange var2);

    public void release(C connection) {
        LOG.debug("{} released", connection);
        HttpClient client = this.getHttpClient();
        if (client.isRunning()) {
            if (this.connectionPool.isActive((Connection)connection)) {
                this.process(connection, false);
            } else {
                LOG.debug("{} explicit", connection);
            }
        } else {
            LOG.debug("{} is stopped", client);
            this.close((Connection)connection);
            connection.close();
        }
    }

    @Override
    public void close(Connection oldConnection) {
        C newConnection;
        super.close(oldConnection);
        this.connectionPool.remove(oldConnection);
        if (!this.getHttpExchanges().isEmpty() && (newConnection = this.acquire()) != null) {
            this.process(newConnection, false);
        }
    }

    @Override
    public void close() {
        super.close();
        this.connectionPool.close();
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        ContainerLifeCycle.dump(out, indent, Arrays.asList(this.connectionPool));
    }
}

