/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client.http;

import com.facebook.presto.jdbc.internal.jetty.client.HttpChannel;
import com.facebook.presto.jdbc.internal.jetty.client.HttpExchange;
import com.facebook.presto.jdbc.internal.jetty.client.api.Result;
import com.facebook.presto.jdbc.internal.jetty.client.http.HttpConnectionOverHTTP;
import com.facebook.presto.jdbc.internal.jetty.client.http.HttpReceiverOverHTTP;
import com.facebook.presto.jdbc.internal.jetty.client.http.HttpSenderOverHTTP;
import com.facebook.presto.jdbc.internal.jetty.http.HttpFields;
import com.facebook.presto.jdbc.internal.jetty.http.HttpHeader;
import com.facebook.presto.jdbc.internal.jetty.http.HttpHeaderValue;

public class HttpChannelOverHTTP
extends HttpChannel {
    private final HttpConnectionOverHTTP connection;
    private final HttpSenderOverHTTP sender;
    private final HttpReceiverOverHTTP receiver;

    public HttpChannelOverHTTP(HttpConnectionOverHTTP connection) {
        super(connection.getHttpDestination());
        this.connection = connection;
        this.sender = new HttpSenderOverHTTP(this);
        this.receiver = new HttpReceiverOverHTTP(this);
    }

    public HttpConnectionOverHTTP getHttpConnection() {
        return this.connection;
    }

    @Override
    public void send() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.sender.send(exchange);
        }
    }

    @Override
    public void proceed(HttpExchange exchange, Throwable failure) {
        this.sender.proceed(exchange, failure);
    }

    @Override
    public boolean abort(Throwable cause) {
        this.sender.abort(cause);
        return this.receiver.abort(cause);
    }

    public void receive() {
        this.receiver.receive();
    }

    @Override
    public void exchangeTerminated(Result result) {
        super.exchangeTerminated(result);
        boolean close = result.isFailed();
        HttpFields responseHeaders = result.getResponse().getHeaders();
        if (close |= responseHeaders.contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString())) {
            this.connection.close();
        } else {
            this.connection.release();
        }
    }

    @Override
    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

