/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.util;

import com.facebook.presto.jdbc.internal.jetty.util.Promise;
import com.facebook.presto.jdbc.internal.jetty.util.log.Log;
import com.facebook.presto.jdbc.internal.jetty.util.log.Logger;
import com.facebook.presto.jdbc.internal.jetty.util.thread.Scheduler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.UnresolvedAddressException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class SocketAddressResolver {
    private static final Logger LOG = Log.getLogger(SocketAddressResolver.class);
    private final Executor executor;
    private final Scheduler scheduler;
    private final long timeout;

    public SocketAddressResolver(Executor executor, Scheduler scheduler, long timeout) {
        this.executor = executor;
        this.scheduler = scheduler;
        this.timeout = timeout;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void resolve(String host, int port, Promise<SocketAddress> promise) {
        this.resolve(host, port, this.timeout, promise);
    }

    protected void resolve(final String host, final int port, final long timeout, final Promise<SocketAddress> promise) {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Scheduler.Task task = null;
                final AtomicBoolean complete = new AtomicBoolean();
                if (timeout > 0L) {
                    final Thread thread = Thread.currentThread();
                    task = SocketAddressResolver.this.scheduler.schedule(new Runnable(){

                        @Override
                        public void run() {
                            if (complete.compareAndSet(false, true)) {
                                promise.failed(new TimeoutException());
                                thread.interrupt();
                            }
                        }
                    }, timeout, TimeUnit.MILLISECONDS);
                }
                try {
                    long start = System.nanoTime();
                    InetSocketAddress result = new InetSocketAddress(host, port);
                    long elapsed = System.nanoTime() - start;
                    LOG.debug("Resolved {} in {} ms", host, TimeUnit.NANOSECONDS.toMillis(elapsed));
                    if (complete.compareAndSet(false, true)) {
                        if (result.isUnresolved()) {
                            promise.failed(new UnresolvedAddressException());
                        } else {
                            promise.succeeded(result);
                        }
                    }
                }
                catch (Throwable x) {
                    if (complete.compareAndSet(false, true)) {
                        promise.failed(x);
                    }
                }
                finally {
                    if (task != null) {
                        task.cancel();
                    }
                    Thread.interrupted();
                }
            }
        });
    }
}

