/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.client;

import com.facebook.presto.jdbc.internal.client.Column;
import com.facebook.presto.jdbc.internal.client.QueryError;
import com.facebook.presto.jdbc.internal.client.StatementStats;
import com.facebook.presto.jdbc.internal.guava.base.Objects;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableList;
import com.facebook.presto.jdbc.internal.guava.collect.Iterables;
import com.facebook.presto.jdbc.internal.guava.io.BaseEncoding;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.validation.constraints.NotNull;

@Immutable
public class QueryResults {
    private final String id;
    private final URI infoUri;
    private final URI partialCancelUri;
    private final URI nextUri;
    private final List<Column> columns;
    private final Iterable<List<Object>> data;
    private final StatementStats stats;
    private final QueryError error;

    @JsonCreator
    public QueryResults(@JsonProperty(value="id") String id, @JsonProperty(value="infoUri") URI infoUri, @JsonProperty(value="partialCancelUri") URI partialCancelUri, @JsonProperty(value="nextUri") URI nextUri, @JsonProperty(value="columns") List<Column> columns, @JsonProperty(value="data") List<List<Object>> data, @JsonProperty(value="stats") StatementStats stats, @JsonProperty(value="error") QueryError error) {
        this(id, infoUri, partialCancelUri, nextUri, columns, QueryResults.fixData(columns, data), stats, error);
    }

    public QueryResults(String id, URI infoUri, URI partialCancelUri, URI nextUri, List<Column> columns, Iterable<List<Object>> data, StatementStats stats, QueryError error) {
        this.id = Preconditions.checkNotNull(id, "id is null");
        this.infoUri = Preconditions.checkNotNull(infoUri, "infoUri is null");
        this.partialCancelUri = partialCancelUri;
        this.nextUri = nextUri;
        this.columns = columns != null ? ImmutableList.copyOf(columns) : null;
        this.data = data != null ? Iterables.unmodifiableIterable(data) : null;
        this.stats = Preconditions.checkNotNull(stats, "stats is null");
        this.error = error;
    }

    @NotNull
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @NotNull
    @JsonProperty
    public URI getInfoUri() {
        return this.infoUri;
    }

    @Nullable
    @JsonProperty
    public URI getPartialCancelUri() {
        return this.partialCancelUri;
    }

    @Nullable
    @JsonProperty
    public URI getNextUri() {
        return this.nextUri;
    }

    @Nullable
    @JsonProperty
    public List<Column> getColumns() {
        return this.columns;
    }

    @Nullable
    @JsonProperty
    public Iterable<List<Object>> getData() {
        return this.data;
    }

    @NotNull
    @JsonProperty
    public StatementStats getStats() {
        return this.stats;
    }

    @Nullable
    @JsonProperty
    public QueryError getError() {
        return this.error;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("id", this.id).add("infoUri", this.infoUri).add("partialCancelUri", this.partialCancelUri).add("nextUri", this.nextUri).add("columns", this.columns).add("hasData", this.data != null).add("stats", this.stats).add("error", this.error).toString();
    }

    private static Iterable<List<Object>> fixData(List<Column> columns, List<List<Object>> data) {
        if (data == null) {
            return null;
        }
        Preconditions.checkNotNull(columns, "columns is null");
        ImmutableList.Builder rows = ImmutableList.builder();
        for (List<Object> row : data) {
            Preconditions.checkArgument(row.size() == columns.size(), "row/column size mismatch");
            ArrayList<Object> newRow = new ArrayList<Object>();
            for (int i = 0; i < row.size(); ++i) {
                newRow.add(QueryResults.fixValue(columns.get(i).getType(), row.get(i)));
            }
            rows.add(Collections.unmodifiableList(newRow));
        }
        return rows.build();
    }

    private static Object fixValue(String type, Object value) {
        if (value == null) {
            return null;
        }
        switch (type) {
            case "bigint": {
                return ((Number)value).longValue();
            }
            case "double": {
                if (value instanceof String) {
                    return Double.parseDouble((String)value);
                }
                return ((Number)value).doubleValue();
            }
            case "boolean": {
                return Boolean.class.cast(value);
            }
            case "varchar": 
            case "time": 
            case "time with time zone": 
            case "timestamp": 
            case "timestamp with time zone": 
            case "date": 
            case "interval year to month": 
            case "interval day to second": {
                return String.class.cast(value);
            }
        }
        if (value instanceof String) {
            return BaseEncoding.base64().decode((String)value);
        }
        return value;
    }
}

