/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client;

import com.facebook.presto.jdbc.internal.airlift.http.client.AsyncHttpClientModule;
import com.facebook.presto.jdbc.internal.airlift.http.client.HttpRequestFilter;
import com.facebook.presto.jdbc.internal.airlift.http.client.TraceTokenRequestFilter;
import com.facebook.presto.jdbc.internal.guava.annotations.Beta;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.Multibinder;
import java.lang.annotation.Annotation;
import java.util.Collection;

@Beta
public class HttpClientBinder {
    private final Binder binder;

    private HttpClientBinder(Binder binder) {
        this.binder = Preconditions.checkNotNull(binder, "binder is null");
    }

    public static HttpClientBinder httpClientBinder(Binder binder) {
        return new HttpClientBinder(binder);
    }

    public HttpClientBindingBuilder bindHttpClient(String name, Class<? extends Annotation> annotation) {
        Preconditions.checkNotNull(name, "name is null");
        Preconditions.checkNotNull(annotation, "annotation is null");
        return this.createBindingBuilder(new AsyncHttpClientModule(name, annotation));
    }

    private HttpClientBindingBuilder createBindingBuilder(AsyncHttpClientModule module) {
        this.binder.install((Module)module);
        return new HttpClientBindingBuilder(module, (Multibinder<HttpRequestFilter>)Multibinder.newSetBinder((Binder)this.binder, HttpRequestFilter.class, (Annotation)module.getFilterQualifier()));
    }

    @Deprecated
    public HttpClientAsyncBindingBuilder bindAsyncHttpClient(String name, Class<? extends Annotation> annotation) {
        Preconditions.checkNotNull(name, "name is null");
        Preconditions.checkNotNull(annotation, "annotation is null");
        return this.createAsyncBindingBuilder(new AsyncHttpClientModule(name, annotation));
    }

    private HttpClientAsyncBindingBuilder createAsyncBindingBuilder(AsyncHttpClientModule module) {
        this.binder.install((Module)module);
        return new HttpClientAsyncBindingBuilder(module, Multibinder.newSetBinder((Binder)this.binder, HttpRequestFilter.class, (Annotation)module.getFilterQualifier()));
    }

    public static class HttpClientAsyncBindingBuilder {
        private final AsyncHttpClientModule module;
        private final Multibinder<HttpRequestFilter> multibinder;

        private HttpClientAsyncBindingBuilder(AsyncHttpClientModule module, Multibinder<HttpRequestFilter> multibinder) {
            this.module = module;
            this.multibinder = multibinder;
        }

        public HttpClientAsyncBindingBuilder withAlias(Class<? extends Annotation> alias) {
            this.module.addAlias(alias);
            return this;
        }

        public HttpClientAsyncBindingBuilder withAliases(Collection<Class<? extends Annotation>> aliases) {
            for (Class<? extends Annotation> annotation : aliases) {
                this.module.addAlias(annotation);
            }
            return this;
        }

        public LinkedBindingBuilder<HttpRequestFilter> addFilterBinding() {
            return this.multibinder.addBinding();
        }

        public HttpClientAsyncBindingBuilder withFilter(Class<? extends HttpRequestFilter> filterClass) {
            this.multibinder.addBinding().to(filterClass);
            return this;
        }

        public HttpClientAsyncBindingBuilder withTracing() {
            return this.withFilter(TraceTokenRequestFilter.class);
        }

        public HttpClientAsyncBindingBuilder withPrivateIoThreadPool() {
            this.module.withPrivateIoThreadPool();
            return this;
        }
    }

    public static class HttpClientBindingBuilder
    extends HttpClientAsyncBindingBuilder {
        public HttpClientBindingBuilder(AsyncHttpClientModule module, Multibinder<HttpRequestFilter> multibinder) {
            super(module, multibinder);
        }
    }
}

