/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client.util;

import com.facebook.presto.jdbc.internal.jetty.client.api.ContentProvider;
import com.facebook.presto.jdbc.internal.jetty.util.BufferUtil;
import com.facebook.presto.jdbc.internal.jetty.util.log.Log;
import com.facebook.presto.jdbc.internal.jetty.util.log.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class InputStreamContentProvider
implements ContentProvider {
    private static final Logger LOG = Log.getLogger(InputStreamContentProvider.class);
    private final InputStream stream;
    private final int bufferSize;
    private final boolean autoClose;

    public InputStreamContentProvider(InputStream stream) {
        this(stream, 4096);
    }

    public InputStreamContentProvider(InputStream stream, int bufferSize) {
        this(stream, bufferSize, true);
    }

    public InputStreamContentProvider(InputStream stream, int bufferSize, boolean autoClose) {
        this.stream = stream;
        this.bufferSize = bufferSize;
        this.autoClose = autoClose;
    }

    @Override
    public long getLength() {
        return -1L;
    }

    protected ByteBuffer onRead(byte[] buffer, int offset, int length) {
        if (length <= 0) {
            return BufferUtil.EMPTY_BUFFER;
        }
        return ByteBuffer.wrap(buffer, offset, length);
    }

    protected void onReadFailure(Throwable failure) {
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return new InputStreamIterator();
    }

    private class InputStreamIterator
    implements Iterator<ByteBuffer>,
    Closeable {
        private Throwable failure;
        private ByteBuffer buffer;
        private Boolean hasNext;

        private InputStreamIterator() {
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.hasNext != null) {
                    return this.hasNext;
                }
                byte[] bytes = new byte[InputStreamContentProvider.this.bufferSize];
                int read = InputStreamContentProvider.this.stream.read(bytes);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Read {} bytes from {}", read, InputStreamContentProvider.this.stream);
                }
                if (read > 0) {
                    this.hasNext = Boolean.TRUE;
                    this.buffer = InputStreamContentProvider.this.onRead(bytes, 0, read);
                    return true;
                }
                if (read < 0) {
                    this.hasNext = Boolean.FALSE;
                    this.buffer = null;
                    this.close();
                    return false;
                }
                this.hasNext = Boolean.TRUE;
                this.buffer = BufferUtil.EMPTY_BUFFER;
                return true;
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(x);
                }
                if (this.failure == null) {
                    this.failure = x;
                    InputStreamContentProvider.this.onReadFailure(x);
                    this.hasNext = Boolean.TRUE;
                    this.buffer = null;
                    this.close();
                    return true;
                }
                throw new IllegalStateException();
            }
        }

        @Override
        public ByteBuffer next() {
            if (this.failure != null) {
                this.hasNext = Boolean.FALSE;
                this.buffer = null;
                throw (NoSuchElementException)new NoSuchElementException().initCause(this.failure);
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ByteBuffer result = this.buffer;
            if (result == null) {
                this.hasNext = Boolean.FALSE;
                this.buffer = null;
                throw new NoSuchElementException();
            }
            this.hasNext = null;
            this.buffer = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            if (InputStreamContentProvider.this.autoClose) {
                try {
                    InputStreamContentProvider.this.stream.close();
                }
                catch (IOException x) {
                    LOG.ignore(x);
                }
            }
        }
    }
}

