/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.type;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonIgnore;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.type.SerializableNativeValue;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;

public final class Marker
implements Comparable<Marker> {
    private final Class<?> type;
    private final Comparable<?> value;
    private final Bound bound;

    private Marker(Class<?> type, Comparable<?> value, Bound bound) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(bound, "bound is null");
        if (!Marker.verifySelfComparable(type)) {
            throw new IllegalArgumentException("type must be comparable to itself: " + type);
        }
        if (value == null && bound == Bound.EXACTLY) {
            throw new IllegalArgumentException("Can not be equal to unbounded");
        }
        if (value != null && !type.isInstance(value)) {
            throw new IllegalArgumentException(String.format("value (%s) must be of specified type (%s)", value, type));
        }
        this.type = type;
        this.value = value;
        this.bound = bound;
    }

    @JsonCreator
    public Marker(@JsonProperty(value="value") SerializableNativeValue value, @JsonProperty(value="bound") Bound bound) {
        this(value.getType(), value.getValue(), bound);
    }

    private static boolean verifySelfComparable(Class<?> type) {
        for (Type interfaceType : type.getGenericInterfaces()) {
            Type[] actualTypeArguments;
            Type typeArgument;
            ParameterizedType parameterizedType;
            if (!(interfaceType instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)interfaceType).getRawType().equals(Comparable.class) || !(typeArgument = (actualTypeArguments = parameterizedType.getActualTypeArguments())[0]).equals(type)) continue;
            return true;
        }
        return false;
    }

    public static Marker upperUnbounded(Class<?> type) {
        return new Marker(type, null, Bound.BELOW);
    }

    public static Marker lowerUnbounded(Class<?> type) {
        return new Marker(type, null, Bound.ABOVE);
    }

    public static Marker above(Comparable<?> value) {
        Objects.requireNonNull(value, "value is null");
        return new Marker(value.getClass(), value, Bound.ABOVE);
    }

    public static Marker exactly(Comparable<?> value) {
        Objects.requireNonNull(value, "value is null");
        return new Marker(value.getClass(), value, Bound.EXACTLY);
    }

    public static Marker below(Comparable<?> value) {
        Objects.requireNonNull(value, "value is null");
        return new Marker(value.getClass(), value, Bound.BELOW);
    }

    @JsonIgnore
    public Class<?> getType() {
        return this.type;
    }

    @JsonIgnore
    public Comparable<?> getValue() {
        if (this.value == null) {
            throw new IllegalStateException("Can not get value for unbounded");
        }
        return this.value;
    }

    @JsonProperty(value="value")
    public SerializableNativeValue getSerializableNativeValue() {
        return new SerializableNativeValue(this.type, this.value);
    }

    @JsonProperty
    public Bound getBound() {
        return this.bound;
    }

    @JsonIgnore
    public boolean isUpperUnbounded() {
        return this.value == null && this.bound == Bound.BELOW;
    }

    @JsonIgnore
    public boolean isLowerUnbounded() {
        return this.value == null && this.bound == Bound.ABOVE;
    }

    private void checkTypeCompatibility(Marker marker) {
        if (!this.type.equals(marker.getType())) {
            throw new IllegalArgumentException(String.format("Mismatched Marker types: %s vs %s", this.type, marker.getType()));
        }
    }

    public boolean isAdjacent(Marker other) {
        this.checkTypeCompatibility(other);
        if (this.isUpperUnbounded() || this.isLowerUnbounded() || other.isUpperUnbounded() || other.isLowerUnbounded()) {
            return false;
        }
        if (Marker.compare(this.value, other.value) != 0) {
            return false;
        }
        return this.bound == Bound.EXACTLY && other.bound != Bound.EXACTLY || this.bound != Bound.EXACTLY && other.bound == Bound.EXACTLY;
    }

    public Marker greaterAdjacent() {
        if (this.value == null) {
            throw new IllegalStateException("No marker adjacent to unbounded");
        }
        switch (this.bound) {
            case BELOW: {
                return new Marker(this.type, this.value, Bound.EXACTLY);
            }
            case EXACTLY: {
                return new Marker(this.type, this.value, Bound.ABOVE);
            }
            case ABOVE: {
                throw new IllegalStateException("No greater marker adjacent to an ABOVE bound");
            }
        }
        throw new AssertionError((Object)("Unsupported type: " + (Object)((Object)this.bound)));
    }

    public Marker lesserAdjacent() {
        if (this.value == null) {
            throw new IllegalStateException("No marker adjacent to unbounded");
        }
        switch (this.bound) {
            case BELOW: {
                throw new IllegalStateException("No lesser marker adjacent to a BELOW bound");
            }
            case EXACTLY: {
                return new Marker(this.type, this.value, Bound.BELOW);
            }
            case ABOVE: {
                return new Marker(this.type, this.value, Bound.EXACTLY);
            }
        }
        throw new AssertionError((Object)("Unsupported type: " + (Object)((Object)this.bound)));
    }

    @Override
    public int compareTo(Marker o) {
        this.checkTypeCompatibility(o);
        if (this.isUpperUnbounded()) {
            return o.isUpperUnbounded() ? 0 : 1;
        }
        if (this.isLowerUnbounded()) {
            return o.isLowerUnbounded() ? 0 : -1;
        }
        if (o.isUpperUnbounded()) {
            return -1;
        }
        if (o.isLowerUnbounded()) {
            return 1;
        }
        int compare = Marker.compare(this.value, o.value);
        if (compare == 0) {
            if (this.bound == o.bound) {
                return 0;
            }
            if (this.bound == Bound.BELOW) {
                return -1;
            }
            if (this.bound == Bound.ABOVE) {
                return 1;
            }
            return o.bound == Bound.BELOW ? 1 : -1;
        }
        return compare;
    }

    private static int compare(Comparable<?> value1, Comparable<?> value2) {
        return value1.compareTo(value2);
    }

    public static Marker min(Marker marker1, Marker marker2) {
        return marker1.compareTo(marker2) <= 0 ? marker1 : marker2;
    }

    public static Marker max(Marker marker1, Marker marker2) {
        return marker1.compareTo(marker2) >= 0 ? marker1 : marker2;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value, this.bound});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Marker other = (Marker)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value) && Objects.equals((Object)this.bound, (Object)other.bound);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Marker{");
        sb.append("type=").append(this.type);
        sb.append(", value=").append(this.value);
        sb.append(", bound=").append((Object)this.bound);
        sb.append('}');
        return sb.toString();
    }

    public static enum Bound {
        BELOW,
        EXACTLY,
        ABOVE;

    }
}

