/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.type;

import com.facebook.presto.jdbc.internal.type.block.Block;
import java.util.Arrays;
import java.util.Objects;

public class Page {
    private final Block[] blocks;
    private final int positionCount;
    private final long sizeInBytes;

    public Page(Block ... blocks) {
        this(Page.determinePositionCount(blocks), blocks);
    }

    public Page(int positionCount, Block ... blocks) {
        Objects.requireNonNull(blocks, "blocks is null");
        this.blocks = Arrays.copyOf(blocks, blocks.length);
        this.positionCount = positionCount;
        long sizeInBytes = 0L;
        for (Block block : blocks) {
            sizeInBytes += (long)block.getSizeInBytes();
        }
        this.sizeInBytes = sizeInBytes;
    }

    public int getChannelCount() {
        return this.blocks.length;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public Block[] getBlocks() {
        return (Block[])this.blocks.clone();
    }

    public Block getBlock(int channel) {
        return this.blocks[channel];
    }

    public void release() {
        for (Block block : this.blocks) {
            block.release();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Page{");
        builder.append("positions=").append(this.positionCount);
        builder.append(", channels=").append(this.getChannelCount());
        builder.append('}');
        builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
        return builder.toString();
    }

    private static int determinePositionCount(Block ... blocks) {
        Objects.requireNonNull(blocks, "blocks is null");
        if (blocks.length == 0) {
            throw new IllegalArgumentException("blocks is empty");
        }
        return blocks[0].getPositionCount();
    }
}

