/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.type;

import com.facebook.presto.jdbc.internal.type.Page;
import com.facebook.presto.jdbc.internal.type.block.Block;
import com.facebook.presto.jdbc.internal.type.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.type.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.type.type.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PageBuilder {
    private final BlockBuilder[] blockBuilders;
    private final List<Type> types;
    private BlockBuilderStatus blockBuilderStatus;
    private int declaredPositions;

    public PageBuilder(List<? extends Type> types) {
        int maxBlockSizeInBytes;
        this.types = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(types, "types is null")));
        if (!types.isEmpty()) {
            maxBlockSizeInBytes = (int)(1048576.0 / (double)types.size());
            maxBlockSizeInBytes = Math.min(65536, maxBlockSizeInBytes);
        } else {
            maxBlockSizeInBytes = 0;
        }
        this.blockBuilderStatus = new BlockBuilderStatus(0x100000, maxBlockSizeInBytes);
        this.blockBuilders = new BlockBuilder[types.size()];
        for (int i = 0; i < this.blockBuilders.length; ++i) {
            this.blockBuilders[i] = types.get(i).createBlockBuilder(this.blockBuilderStatus);
        }
    }

    public void reset() {
        if (this.isEmpty()) {
            return;
        }
        this.declaredPositions = 0;
        this.blockBuilderStatus = new BlockBuilderStatus(this.blockBuilderStatus);
        for (int i = 0; i < this.types.size(); ++i) {
            this.blockBuilders[i] = this.types.get(i).createBlockBuilder(this.blockBuilderStatus);
        }
    }

    public BlockBuilder getBlockBuilder(int channel) {
        return this.blockBuilders[channel];
    }

    public void declarePosition() {
        ++this.declaredPositions;
    }

    public boolean isFull() {
        return this.declaredPositions == Integer.MAX_VALUE || this.blockBuilderStatus.isFull();
    }

    public boolean isEmpty() {
        return this.blockBuilders.length == 0 ? this.declaredPositions == 0 : this.blockBuilderStatus.isEmpty();
    }

    public int getPositionCount() {
        return this.declaredPositions;
    }

    public long getSizeInBytes() {
        return this.blockBuilderStatus.getSizeInBytes();
    }

    public Page build() {
        if (this.blockBuilders.length == 0) {
            return new Page(this.declaredPositions, new Block[0]);
        }
        Block[] blocks = new Block[this.blockBuilders.length];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = this.blockBuilders[i].build();
        }
        return new Page(blocks);
    }
}

