/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.type;

import com.facebook.presto.jdbc.internal.type.ErrorCode;

public class PrestoException
extends RuntimeException {
    private final ErrorCode errorCode;

    public PrestoException(ErrorCode errorCode, String message) {
        this(errorCode, message, null);
    }

    public PrestoException(ErrorCode errorCode, Throwable throwable) {
        this(errorCode, null, throwable);
    }

    public PrestoException(ErrorCode errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    public PrestoException(ErrorCode errorCode, String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.errorCode = errorCode;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (message == null && this.getCause() != null) {
            message = this.getCause().getMessage();
        }
        if (message == null) {
            message = this.errorCode.getName();
        }
        return message;
    }
}

