/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.type;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonValue;
import com.facebook.presto.jdbc.internal.type.SchemaTablePrefix;
import com.facebook.presto.jdbc.internal.type.SchemaUtil;
import java.util.Objects;

public class SchemaTableName {
    private final String schemaName;
    private final String tableName;

    @JsonCreator
    public static SchemaTableName valueOf(String schemaTableName) {
        SchemaUtil.checkNotEmpty(schemaTableName, "schemaTableName");
        String[] parts = schemaTableName.split("\\.");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid schemaTableName " + schemaTableName);
        }
        return new SchemaTableName(parts[0], parts[1]);
    }

    public SchemaTableName(String schemaName, String tableName) {
        this.schemaName = SchemaUtil.checkNotEmpty(schemaName, "schemaName");
        this.tableName = SchemaUtil.checkNotEmpty(tableName, "tableName");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaTableName other = (SchemaTableName)obj;
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName);
    }

    @JsonValue
    public String toString() {
        return this.schemaName + '.' + this.tableName;
    }

    public SchemaTablePrefix toSchemaTablePrefix() {
        return new SchemaTablePrefix(this.schemaName, this.tableName);
    }
}

