/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.type;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.jackson.core.JsonGenerator;
import com.facebook.presto.jdbc.internal.jackson.core.JsonParser;
import com.facebook.presto.jdbc.internal.jackson.core.JsonToken;
import com.facebook.presto.jdbc.internal.jackson.core.io.SerializedString;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationContext;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonSerializer;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializerProvider;
import com.facebook.presto.jdbc.internal.jackson.databind.annotation.JsonDeserialize;
import com.facebook.presto.jdbc.internal.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class SerializableNativeValue {
    private final Class<?> type;
    private final Comparable<?> value;

    public SerializableNativeValue(Class<?> type, Comparable<?> value) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.value = value;
        if (value != null && !type.isInstance(value)) {
            throw new IllegalArgumentException(String.format("type %s does not match value %s", type.getClass(), value));
        }
    }

    public Class<?> getType() {
        return this.type;
    }

    public Comparable<?> getValue() {
        return this.value;
    }

    public static class Deserializer
    extends JsonDeserializer<SerializableNativeValue> {
        @Override
        public SerializableNativeValue deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            Deserializer.checkJson(jsonParser.nextFieldName(new SerializedString("type")));
            String typeString = jsonParser.nextTextValue();
            Class<?> type = Deserializer.extractClassType(typeString);
            Deserializer.checkJson(jsonParser.nextFieldName(new SerializedString("value")));
            JsonToken token = jsonParser.nextToken();
            Comparable<?> value = token == JsonToken.VALUE_NULL ? null : Deserializer.readValue(type, jsonParser);
            Deserializer.checkJson(jsonParser.nextToken() == JsonToken.END_OBJECT);
            return new SerializableNativeValue(type, value);
        }

        private static Comparable<?> readValue(Class<?> type, JsonParser jsonParser) throws IOException {
            if (type == String.class) {
                String value = jsonParser.getValueAsString();
                Deserializer.checkJson(value != null);
                return value;
            }
            if (type == Slice.class) {
                String value = jsonParser.getValueAsString();
                Deserializer.checkJson(value != null);
                return Slices.copiedBuffer(value, StandardCharsets.UTF_8);
            }
            if (type == Boolean.class) {
                return jsonParser.getBooleanValue();
            }
            if (type == Long.class) {
                return jsonParser.getLongValue();
            }
            if (type.equals(Double.class)) {
                return jsonParser.getDoubleValue();
            }
            throw new AssertionError((Object)("Unknown type: " + type));
        }

        private static void checkJson(boolean condition) {
            if (!condition) {
                throw new IllegalArgumentException("Malformed SerializableNativeValue JSON object");
            }
        }

        private static Class<?> extractClassType(String typeString) {
            try {
                return Class.forName(typeString);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Unknown class type: " + typeString);
            }
        }
    }

    public static class Serializer
    extends JsonSerializer<SerializableNativeValue> {
        @Override
        public void serialize(SerializableNativeValue value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", value.getType().getCanonicalName());
            generator.writeFieldName("value");
            if (value.getValue() == null) {
                generator.writeNull();
            } else {
                Serializer.writeValue(value, generator);
            }
            generator.writeEndObject();
        }

        private static void writeValue(SerializableNativeValue value, JsonGenerator jsonGenerator) throws IOException {
            Class<?> type = value.getType();
            if (type == String.class) {
                jsonGenerator.writeString((String)((Object)value.getValue()));
            } else if (type == Slice.class) {
                jsonGenerator.writeString(((Slice)value.getValue()).toStringUtf8());
            } else if (type == Boolean.class) {
                jsonGenerator.writeBoolean((Boolean)value.getValue());
            } else if (type == Long.class) {
                jsonGenerator.writeNumber((Long)value.getValue());
            } else if (type == Double.class) {
                jsonGenerator.writeNumber((Double)value.getValue());
            } else {
                throw new AssertionError((Object)("Unknown type: " + type));
            }
        }
    }
}

