/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.type.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.type.block.AbstractFixedWidthBlock;
import com.facebook.presto.jdbc.internal.type.block.Block;
import java.util.Arrays;
import java.util.Objects;

public class FixedWidthBlock
extends AbstractFixedWidthBlock {
    private final int positionCount;
    private final Slice slice;
    private final boolean[] valueIsNull;

    public FixedWidthBlock(int fixedSize, int positionCount, Slice slice, boolean[] valueIsNull) {
        super(fixedSize);
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        this.slice = Objects.requireNonNull(slice, "slice is null");
        if (valueIsNull.length < positionCount) {
            throw new IllegalArgumentException("valueIsNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
    }

    @Override
    protected Slice getRawSlice() {
        return this.slice;
    }

    @Override
    protected boolean isEntryNull(int position) {
        return this.valueIsNull[position];
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getSizeInBytes() {
        long size = (long)this.getRawSlice().length() + SizeOf.sizeOf(this.valueIsNull);
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        if (positionOffset < 0 || length < 0 || positionOffset + length > this.positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + this.positionCount + " positions");
        }
        Slice newSlice = this.slice.slice(positionOffset * this.fixedSize, length * this.fixedSize);
        boolean[] newValueIsNull = Arrays.copyOfRange(this.valueIsNull, positionOffset, positionOffset + length);
        return new FixedWidthBlock(this.fixedSize, length, newSlice, newValueIsNull);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FixedWidthBlock{");
        sb.append("positionCount=").append(this.positionCount);
        sb.append(", fixedSize=").append(this.fixedSize);
        sb.append(", slice=").append(this.slice);
        sb.append('}');
        return sb.toString();
    }
}

