/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.type.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.type.block.AbstractFixedWidthBlock;
import com.facebook.presto.jdbc.internal.type.block.Block;
import java.util.Arrays;

public class LazyFixedWidthBlock
extends AbstractFixedWidthBlock {
    private final int positionCount;
    private final LazyFixedWidthBlockLoader loader;
    private Slice slice;
    private boolean[] valueIsNull;
    private boolean released;

    public LazyFixedWidthBlock(int fixedSize, int positionCount, LazyFixedWidthBlockLoader loader) {
        super(fixedSize);
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (loader == null) {
            throw new IllegalArgumentException("loader is null");
        }
        this.loader = loader;
    }

    LazyFixedWidthBlock(int fixedSize, int positionCount, LazyFixedWidthBlockLoader loader, Slice slice, boolean[] valueIsNull) {
        super(fixedSize);
        this.positionCount = positionCount;
        this.loader = loader;
        this.slice = slice;
        this.valueIsNull = valueIsNull;
    }

    @Override
    protected Slice getRawSlice() {
        this.assureLoaded();
        return this.slice;
    }

    @Override
    protected boolean isEntryNull(int position) {
        this.assureLoaded();
        return this.valueIsNull[position];
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getSizeInBytes() {
        long size = (long)(this.positionCount * this.fixedSize) + SizeOf.sizeOf(this.valueIsNull);
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        if (positionOffset < 0 || length < 0 || positionOffset + length > this.positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + this.positionCount + " positions");
        }
        this.assureLoaded();
        Slice newSlice = this.slice.slice(positionOffset * this.fixedSize, length * this.fixedSize);
        return new LazyFixedWidthBlock(this.fixedSize, length, this.loader, newSlice, Arrays.copyOfRange(this.valueIsNull, positionOffset, positionOffset + length));
    }

    @Override
    public void release() {
        if (this.released) {
            return;
        }
        this.released = true;
        this.loader.release();
    }

    private void assureLoaded() {
        if (this.slice != null) {
            return;
        }
        if (this.released) {
            throw new IllegalArgumentException("block has been released");
        }
        this.loader.load(this);
    }

    public void setRawSlice(Slice slice) {
        if (slice.length() < this.positionCount * this.fixedSize) {
            throw new IllegalArgumentException("slice is not large enough to hold all positions");
        }
        this.slice = slice;
    }

    public void setNullVector(boolean[] valueIsNull) {
        if (valueIsNull.length < this.positionCount) {
            throw new IllegalArgumentException("valueIsNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FixedWidthBlock{");
        sb.append("positionCount=").append(this.positionCount);
        sb.append(", slice=").append(this.slice == null ? "not loaded" : this.slice);
        sb.append('}');
        return sb.toString();
    }

    public static interface LazyFixedWidthBlockLoader {
        public void load(LazyFixedWidthBlock var1);

        public void release();
    }
}

