/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.type.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.type.block.AbstractVariableWidthBlock;
import com.facebook.presto.jdbc.internal.type.block.Block;
import com.facebook.presto.jdbc.internal.type.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.type.block.LazySliceArrayBlockEncoding;
import com.facebook.presto.jdbc.internal.type.block.SliceArrayBlock;
import java.util.Arrays;

public class LazySliceArrayBlock
extends AbstractVariableWidthBlock {
    private final int positionCount;
    private final LazySliceArrayBlockLoader loader;
    private Slice[] values;
    private boolean released;

    public LazySliceArrayBlock(int positionCount, LazySliceArrayBlockLoader loader) {
        this.positionCount = positionCount;
        this.loader = loader;
    }

    Slice[] getValues() {
        this.assureLoaded();
        return this.values;
    }

    public void setValues(Slice[] values) {
        this.values = values;
    }

    @Override
    public BlockEncoding getEncoding() {
        return new LazySliceArrayBlockEncoding();
    }

    @Override
    protected Slice getRawSlice(int position) {
        this.assureLoaded();
        return this.values[position];
    }

    @Override
    protected int getPositionOffset(int position) {
        return 0;
    }

    @Override
    protected boolean isEntryNull(int position) {
        this.assureLoaded();
        return this.values[position] == null;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getLength(int position) {
        this.assureLoaded();
        return this.values[position].length();
    }

    @Override
    public int getSizeInBytes() {
        long size = SizeOf.sizeOf(this.values);
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        this.assureLoaded();
        Slice[] newValues = Arrays.copyOfRange(this.values, positionOffset, positionOffset + length);
        return new SliceArrayBlock(length, newValues);
    }

    @Override
    public void release() {
        if (this.released) {
            return;
        }
        this.released = true;
        this.loader.release();
    }

    private void assureLoaded() {
        if (this.values == null) {
            this.loader.load(this);
        }
        if (this.released) {
            throw new IllegalArgumentException("block has been released");
        }
        this.loader.load(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LazySliceArrayBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    public static interface LazySliceArrayBlockLoader {
        public void load(LazySliceArrayBlock var1);

        public void release();
    }
}

