/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.type.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.type.block.AbstractVariableWidthBlock;
import com.facebook.presto.jdbc.internal.type.block.Block;
import com.facebook.presto.jdbc.internal.type.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.type.block.SliceArrayBlockEncoding;
import java.util.Arrays;

public class SliceArrayBlock
extends AbstractVariableWidthBlock {
    private final int positionCount;
    private final Slice[] values;

    public SliceArrayBlock(int positionCount, Slice[] values) {
        this.positionCount = positionCount;
        if (values.length < positionCount) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
    }

    Slice[] getValues() {
        return this.values;
    }

    @Override
    protected Slice getRawSlice(int position) {
        return this.values[position];
    }

    @Override
    protected int getPositionOffset(int position) {
        return 0;
    }

    @Override
    protected boolean isEntryNull(int position) {
        return this.values[position] == null;
    }

    @Override
    public BlockEncoding getEncoding() {
        return new SliceArrayBlockEncoding();
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getLength(int position) {
        return this.values[position].length();
    }

    @Override
    public int getSizeInBytes() {
        long size = SizeOf.sizeOf(this.values);
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        Slice[] newValues = Arrays.copyOfRange(this.values, positionOffset, positionOffset + length);
        return new SliceArrayBlock(length, newValues);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SliceArrayBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }
}

