/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.type.classloader;

import com.facebook.presto.jdbc.internal.type.ConnectorColumnHandle;
import com.facebook.presto.jdbc.internal.type.ConnectorIndexHandle;
import com.facebook.presto.jdbc.internal.type.ConnectorIndexResolver;
import com.facebook.presto.jdbc.internal.type.ConnectorResolvedIndex;
import com.facebook.presto.jdbc.internal.type.ConnectorTableHandle;
import com.facebook.presto.jdbc.internal.type.Index;
import com.facebook.presto.jdbc.internal.type.TupleDomain;
import com.facebook.presto.jdbc.internal.type.classloader.ThreadContextClassLoader;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ClassLoaderSafeConnectorIndexResolver
implements ConnectorIndexResolver {
    private final ConnectorIndexResolver delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorIndexResolver(ConnectorIndexResolver delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public ConnectorResolvedIndex resolveIndex(ConnectorTableHandle tableHandle, Set<ConnectorColumnHandle> indexableColumns, TupleDomain<ConnectorColumnHandle> tupleDomain) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorResolvedIndex connectorResolvedIndex = this.delegate.resolveIndex(tableHandle, indexableColumns, tupleDomain);
            return connectorResolvedIndex;
        }
    }

    @Override
    public Index getIndex(ConnectorIndexHandle indexHandle, List<ConnectorColumnHandle> lookupSchema, List<ConnectorColumnHandle> outputSchema) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Index index = this.delegate.getIndex(indexHandle, lookupSchema, outputSchema);
            return index;
        }
    }
}

