/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.type.classloader;

import com.facebook.presto.jdbc.internal.type.ConnectorColumnHandle;
import com.facebook.presto.jdbc.internal.type.ConnectorRecordSetProvider;
import com.facebook.presto.jdbc.internal.type.ConnectorSplit;
import com.facebook.presto.jdbc.internal.type.RecordSet;
import com.facebook.presto.jdbc.internal.type.classloader.ClassLoaderSafeRecordSet;
import com.facebook.presto.jdbc.internal.type.classloader.ThreadContextClassLoader;
import java.util.List;
import java.util.Objects;

public class ClassLoaderSafeConnectorRecordSetProvider
implements ConnectorRecordSetProvider {
    private final ConnectorRecordSetProvider delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorRecordSetProvider(ConnectorRecordSetProvider delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public RecordSet getRecordSet(ConnectorSplit split, List<? extends ConnectorColumnHandle> columns) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ClassLoaderSafeRecordSet classLoaderSafeRecordSet = new ClassLoaderSafeRecordSet(this.delegate.getRecordSet(split, columns), this.classLoader);
            return classLoaderSafeRecordSet;
        }
    }

    public String toString() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            String string = this.delegate.toString();
            return string;
        }
    }
}

