/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.type.classloader;

import com.facebook.presto.jdbc.internal.type.ConnectorInsertTableHandle;
import com.facebook.presto.jdbc.internal.type.ConnectorOutputTableHandle;
import com.facebook.presto.jdbc.internal.type.ConnectorRecordSinkProvider;
import com.facebook.presto.jdbc.internal.type.RecordSink;
import com.facebook.presto.jdbc.internal.type.classloader.ThreadContextClassLoader;
import java.util.Objects;

public final class ClassLoaderSafeConnectorRecordSinkProvider
implements ConnectorRecordSinkProvider {
    private final ConnectorRecordSinkProvider delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorRecordSinkProvider(ConnectorRecordSinkProvider delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public RecordSink getRecordSink(ConnectorOutputTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            RecordSink recordSink = this.delegate.getRecordSink(tableHandle);
            return recordSink;
        }
    }

    @Override
    public RecordSink getRecordSink(ConnectorInsertTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            RecordSink recordSink = this.delegate.getRecordSink(tableHandle);
            return recordSink;
        }
    }
}

