/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.type.classloader;

import com.facebook.presto.jdbc.internal.type.RecordCursor;
import com.facebook.presto.jdbc.internal.type.RecordSet;
import com.facebook.presto.jdbc.internal.type.classloader.ThreadContextClassLoader;
import com.facebook.presto.jdbc.internal.type.type.Type;
import java.util.List;
import java.util.Objects;

public class ClassLoaderSafeRecordSet
implements RecordSet {
    private final RecordSet delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeRecordSet(RecordSet delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public List<Type> getColumnTypes() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List<Type> list = this.delegate.getColumnTypes();
            return list;
        }
    }

    @Override
    public RecordCursor cursor() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            RecordCursor recordCursor = this.delegate.cursor();
            return recordCursor;
        }
    }

    public String toString() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            String string = this.delegate.toString();
            return string;
        }
    }
}

