package com.facebook.presto.jdbc.internal.jackson.datatype.joda.deser;

import java.io.IOException;

import com.facebook.presto.jdbc.internal.joda.time.*;

import com.facebook.presto.jdbc.internal.jackson.core.JsonProcessingException;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationContext;
import com.facebook.presto.jdbc.internal.jackson.databind.KeyDeserializer;

public class DateTimeKeyDeserializer extends KeyDeserializer {

  @Override
  public Object deserializeKey(final String key, final DeserializationContext ctxt) throws IOException,
      JsonProcessingException {
    if (key.length() == 0) { // [JACKSON-360]
        return null;
    }
    return new DateTime(key, DateTimeZone.forTimeZone(ctxt.getTimeZone()));
  }

}
