/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.block.AbstractVariableWidthBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.LazyBlockLoader;
import com.facebook.presto.jdbc.internal.spi.block.LazySliceArrayBlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.SliceArrayBlock;
import java.util.Arrays;
import java.util.Objects;

public class LazySliceArrayBlock
extends AbstractVariableWidthBlock {
    private final int positionCount;
    private final LazyBlockLoader<LazySliceArrayBlock> loader;
    private Slice[] values;

    public LazySliceArrayBlock(int positionCount, LazyBlockLoader<LazySliceArrayBlock> loader) {
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        this.loader = Objects.requireNonNull(loader);
    }

    Slice[] getValues() {
        this.assureLoaded();
        return this.values;
    }

    public void setValues(Slice[] values) {
        this.values = values;
    }

    @Override
    public BlockEncoding getEncoding() {
        return new LazySliceArrayBlockEncoding();
    }

    @Override
    protected Slice getRawSlice(int position) {
        this.assureLoaded();
        return this.values[position];
    }

    @Override
    protected int getPositionOffset(int position) {
        return 0;
    }

    @Override
    protected boolean isEntryNull(int position) {
        this.assureLoaded();
        return this.values[position] == null;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getLength(int position) {
        this.assureLoaded();
        return this.values[position].length();
    }

    @Override
    public int getSizeInBytes() {
        long size = SizeOf.sizeOf(this.values);
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        this.assureLoaded();
        Slice[] newValues = Arrays.copyOfRange(this.values, positionOffset, positionOffset + length);
        return new SliceArrayBlock(length, newValues);
    }

    @Override
    public void assureLoaded() {
        if (this.values != null) {
            return;
        }
        this.loader.load(this);
        if (this.values == null) {
            throw new IllegalArgumentException("Lazy block loader did not load this block");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LazySliceArrayBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }
}

