/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class TypeSignature {
    private final String base;
    private final List<TypeSignature> parameters;

    private TypeSignature(String base, List<TypeSignature> parameters) {
        TypeSignature.checkArgument(base != null, "base is null", new Object[0]);
        this.base = base;
        TypeSignature.checkArgument(!base.isEmpty(), "base is empty", new Object[0]);
        TypeSignature.checkArgument(!Pattern.matches(".*[<>,].*", base), "Bad characters in base type: %s", base);
        TypeSignature.checkArgument(parameters != null, "parameters is null", new Object[0]);
        this.parameters = Collections.unmodifiableList(new ArrayList<TypeSignature>(parameters));
    }

    @JsonValue
    public String toString() {
        String typeName = this.base;
        if (!this.parameters.isEmpty()) {
            typeName = typeName + "<";
            boolean first = true;
            for (TypeSignature parameter : this.parameters) {
                if (!first) {
                    typeName = typeName + ",";
                }
                first = false;
                typeName = typeName + parameter.toString();
            }
            typeName = typeName + ">";
        }
        return typeName;
    }

    @JsonProperty
    public String getBase() {
        return this.base;
    }

    @JsonProperty
    public List<TypeSignature> getParameters() {
        return this.parameters;
    }

    @JsonCreator
    public static TypeSignature parseTypeSignature(String signature) {
        if (!signature.contains("<")) {
            return new TypeSignature(signature, Collections.unmodifiableList(new ArrayList()));
        }
        String baseName = null;
        ArrayList<TypeSignature> parameters = new ArrayList<TypeSignature>();
        int parameterStart = -1;
        int bracketCount = 0;
        for (int i = 0; i < signature.length(); ++i) {
            char c = signature.charAt(i);
            if (c == '<') {
                if (bracketCount == 0) {
                    TypeSignature.checkState(baseName == null, "Expected baseName to be null", new Object[0]);
                    TypeSignature.checkState(parameterStart == -1, "Expected parameter start to be -1", new Object[0]);
                    baseName = signature.substring(0, i);
                    parameterStart = i + 1;
                }
                ++bracketCount;
                continue;
            }
            if (c == '>') {
                TypeSignature.checkArgument(--bracketCount >= 0, "Bad type signature: '%s'", signature);
                if (bracketCount != 0) continue;
                TypeSignature.checkArgument(i == signature.length() - 1, "Bad type signature: '%s'", signature);
                TypeSignature.checkArgument(parameterStart >= 0, "Bad type signature: '%s'", signature);
                parameters.add(TypeSignature.parseTypeSignature(signature.substring(parameterStart, i)));
                return new TypeSignature(baseName, parameters);
            }
            if (c != ',' || bracketCount != 1) continue;
            TypeSignature.checkArgument(parameterStart >= 0, "Bad type signature: '%s'", signature);
            parameters.add(TypeSignature.parseTypeSignature(signature.substring(parameterStart, i)));
            parameterStart = i + 1;
        }
        throw new IllegalArgumentException(String.format("Bad type signature: '%s'", signature));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeSignature other = (TypeSignature)o;
        return Objects.equals(this.base, other.base) && Objects.equals(this.parameters, other.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.base, this.parameters);
    }

    private static void checkArgument(boolean argument, String format, Object ... args) {
        if (!argument) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }

    private static void checkState(boolean argument, String format, Object ... args) {
        if (!argument) {
            throw new IllegalStateException(String.format(format, args));
        }
    }
}

