/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.guava;

import com.facebook.presto.jdbc.internal.guava.base.Optional;
import com.facebook.presto.jdbc.internal.guava.collect.ArrayListMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.BiMap;
import com.facebook.presto.jdbc.internal.guava.collect.EnumBiMap;
import com.facebook.presto.jdbc.internal.guava.collect.EnumHashBiMap;
import com.facebook.presto.jdbc.internal.guava.collect.EnumMultiset;
import com.facebook.presto.jdbc.internal.guava.collect.ForwardingListMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.ForwardingSetMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.ForwardingSortedSetMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.HashBiMap;
import com.facebook.presto.jdbc.internal.guava.collect.HashMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.HashMultiset;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableBiMap;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableCollection;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableList;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableListMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableMap;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableMultiset;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableSet;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableSetMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableSortedMap;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableSortedSet;
import com.facebook.presto.jdbc.internal.guava.collect.LinkedHashMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.LinkedHashMultiset;
import com.facebook.presto.jdbc.internal.guava.collect.LinkedListMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.ListMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.Multimap;
import com.facebook.presto.jdbc.internal.guava.collect.Multiset;
import com.facebook.presto.jdbc.internal.guava.collect.Range;
import com.facebook.presto.jdbc.internal.guava.collect.SetMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.SortedSetMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.Table;
import com.facebook.presto.jdbc.internal.guava.collect.TreeMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.TreeMultiset;
import com.facebook.presto.jdbc.internal.guava.net.HostAndPort;
import com.facebook.presto.jdbc.internal.jackson.databind.BeanDescription;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationConfig;
import com.facebook.presto.jdbc.internal.jackson.databind.JavaType;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonMappingException;
import com.facebook.presto.jdbc.internal.jackson.databind.KeyDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.deser.Deserializers;
import com.facebook.presto.jdbc.internal.jackson.databind.jsontype.TypeDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.type.CollectionType;
import com.facebook.presto.jdbc.internal.jackson.databind.type.MapLikeType;
import com.facebook.presto.jdbc.internal.jackson.databind.type.MapType;
import com.facebook.presto.jdbc.internal.jackson.databind.type.TypeFactory;
import com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser.GuavaOptionalDeserializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser.HashMultisetDeserializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser.HostAndPortDeserializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser.ImmutableBiMapDeserializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser.ImmutableListDeserializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser.ImmutableMapDeserializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser.ImmutableMultisetDeserializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser.ImmutableSetDeserializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser.ImmutableSortedMapDeserializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser.ImmutableSortedSetDeserializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser.LinkedHashMultisetDeserializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser.RangeDeserializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser.TreeMultisetDeserializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser.multimap.list.ArrayListMultimapDeserializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser.multimap.list.LinkedListMultimapDeserializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser.multimap.set.HashMultimapDeserializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser.multimap.set.LinkedHashMultimapDeserializer;

public class GuavaDeserializers
extends Deserializers.Base {
    @Override
    public JsonDeserializer<?> findCollectionDeserializer(CollectionType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (ImmutableCollection.class.isAssignableFrom(raw)) {
            if (ImmutableList.class.isAssignableFrom(raw)) {
                return new ImmutableListDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
            if (ImmutableMultiset.class.isAssignableFrom(raw)) {
                return new ImmutableMultisetDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
            if (ImmutableSet.class.isAssignableFrom(raw)) {
                if (ImmutableSortedSet.class.isAssignableFrom(raw)) {
                    Class<?> elemType = type.getContentType().getRawClass();
                    if (!Comparable.class.isAssignableFrom(elemType)) {
                        throw new IllegalArgumentException("Can not handle ImmutableSortedSet with elements that are not Comparable<?> (" + raw.getName() + ")");
                    }
                    return new ImmutableSortedSetDeserializer(type, elementTypeDeserializer, elementDeserializer);
                }
                return new ImmutableSetDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
            return new ImmutableListDeserializer(type, elementTypeDeserializer, elementDeserializer);
        }
        if (Multiset.class.isAssignableFrom(raw)) {
            if (LinkedHashMultiset.class.isAssignableFrom(raw)) {
                return new LinkedHashMultisetDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
            if (HashMultiset.class.isAssignableFrom(raw)) {
                return new HashMultisetDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
            if (EnumMultiset.class.isAssignableFrom(raw)) {
                // empty if block
            }
            if (TreeMultiset.class.isAssignableFrom(raw)) {
                return new TreeMultisetDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
            return new HashMultisetDeserializer(type, elementTypeDeserializer, elementDeserializer);
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> findMapDeserializer(MapType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (ImmutableMap.class.isAssignableFrom(raw)) {
            if (ImmutableSortedMap.class.isAssignableFrom(raw)) {
                return new ImmutableSortedMapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (ImmutableBiMap.class.isAssignableFrom(raw)) {
                return new ImmutableBiMapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            return new ImmutableMapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
        if (BiMap.class.isAssignableFrom(raw)) {
            if (EnumBiMap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            if (EnumHashBiMap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            if (HashBiMap.class.isAssignableFrom(raw)) {
                // empty if block
            }
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> findMapLikeDeserializer(MapLikeType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (ListMultimap.class.isAssignableFrom(raw)) {
            if (ImmutableListMultimap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            if (ArrayListMultimap.class.isAssignableFrom(raw)) {
                return new ArrayListMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (LinkedListMultimap.class.isAssignableFrom(raw)) {
                return new LinkedListMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (ForwardingListMultimap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            return new ArrayListMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
        if (SetMultimap.class.isAssignableFrom(raw)) {
            if (SortedSetMultimap.class.isAssignableFrom(raw)) {
                if (TreeMultimap.class.isAssignableFrom(raw)) {
                    // empty if block
                }
                if (ForwardingSortedSetMultimap.class.isAssignableFrom(raw)) {
                    // empty if block
                }
            }
            if (ImmutableSetMultimap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            if (HashMultimap.class.isAssignableFrom(raw)) {
                return new HashMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (LinkedHashMultimap.class.isAssignableFrom(raw)) {
                return new LinkedHashMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (ForwardingSetMultimap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            return new HashMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
        if (Multimap.class.isAssignableFrom(raw)) {
            return new LinkedListMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
        if (Table.class.isAssignableFrom(raw)) {
            // empty if block
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (raw == Optional.class) {
            JavaType[] types = config.getTypeFactory().findTypeParameters(type, Optional.class);
            JavaType refType = types == null ? TypeFactory.unknownType() : types[0];
            JsonDeserializer valueDeser = (JsonDeserializer)type.getValueHandler();
            TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
            if (typeDeser == null) {
                typeDeser = config.findTypeDeserializer(refType);
            }
            return new GuavaOptionalDeserializer(type, refType, typeDeser, valueDeser);
        }
        if (raw == Range.class) {
            return new RangeDeserializer(type);
        }
        if (raw == HostAndPort.class) {
            return HostAndPortDeserializer.std;
        }
        return super.findBeanDeserializer(type, config, beanDesc);
    }
}

