/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.spi.ConnectorSession;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.type.AbstractFixedWidthType;

public final class DoubleType
extends AbstractFixedWidthType {
    public static final DoubleType DOUBLE = new DoubleType();

    private DoubleType() {
        super("double", Double.TYPE, 8);
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return block.getDouble(position, 0);
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        long rightValue;
        long leftValue = leftBlock.getLong(leftPosition, 0);
        return leftValue == (rightValue = rightBlock.getLong(rightPosition, 0));
    }

    @Override
    public int hash(Block block, int position) {
        long value = block.getLong(position, 0);
        return (int)(value ^ value >>> 32);
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        double leftValue = leftBlock.getDouble(leftPosition, 0);
        double rightValue = rightBlock.getDouble(rightPosition, 0);
        return Double.compare(leftValue, rightValue);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeDouble(block.getDouble(position, 0)).closeEntry();
        }
    }

    @Override
    public double getDouble(Block block, int position) {
        return block.getDouble(position, 0);
    }

    @Override
    public void writeDouble(BlockBuilder blockBuilder, double value) {
        blockBuilder.writeDouble(value).closeEntry();
    }
}

