/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.client;

import com.facebook.presto.jdbc.internal.guava.base.Function;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.collect.Lists;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.type.TypeSignature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ClientTypeSignature {
    private static final Pattern PATTERN = Pattern.compile(".*[<>,].*");
    private final String rawType;
    private final List<ClientTypeSignature> typeArguments;
    private final List<Object> literalArguments;

    public ClientTypeSignature(TypeSignature typeSignature) {
        this(typeSignature.getBase(), Lists.transform(typeSignature.getParameters(), new Function<TypeSignature, ClientTypeSignature>(){

            @Override
            public ClientTypeSignature apply(TypeSignature input) {
                return new ClientTypeSignature(input);
            }
        }), typeSignature.getLiteralParameters());
    }

    @JsonCreator
    public ClientTypeSignature(@JsonProperty(value="rawType") String rawType, @JsonProperty(value="typeArguments") List<ClientTypeSignature> typeArguments, @JsonProperty(value="literalArguments") List<Object> literalArguments) {
        Preconditions.checkArgument(rawType != null, "rawType is null");
        this.rawType = rawType;
        Preconditions.checkArgument(!rawType.isEmpty(), "rawType is empty");
        Preconditions.checkArgument(!PATTERN.matcher(rawType).matches(), "Bad characters in rawType type: %s", rawType);
        Preconditions.checkArgument(typeArguments != null, "typeArguments is null");
        Preconditions.checkArgument(literalArguments != null, "literalArguments is null");
        for (Object literal : literalArguments) {
            Preconditions.checkArgument(literal instanceof String || literal instanceof Long, "Unsupported literal type: %s", literal.getClass());
        }
        this.typeArguments = Collections.unmodifiableList(new ArrayList<ClientTypeSignature>(typeArguments));
        this.literalArguments = Collections.unmodifiableList(new ArrayList<Object>(literalArguments));
    }

    @JsonProperty
    public String getRawType() {
        return this.rawType;
    }

    @JsonProperty
    public List<ClientTypeSignature> getTypeArguments() {
        return this.typeArguments;
    }

    @JsonProperty
    public List<Object> getLiteralArguments() {
        return this.literalArguments;
    }

    public String toString() {
        boolean first;
        StringBuilder typeName = new StringBuilder(this.rawType);
        if (!this.typeArguments.isEmpty()) {
            typeName.append("<");
            first = true;
            for (ClientTypeSignature argument : this.typeArguments) {
                if (!first) {
                    typeName.append(",");
                }
                first = false;
                typeName.append(argument.toString());
            }
            typeName.append(">");
        }
        if (!this.literalArguments.isEmpty()) {
            typeName.append("(");
            first = true;
            for (Object parameter : this.literalArguments) {
                if (!first) {
                    typeName.append(",");
                }
                first = false;
                if (parameter instanceof String) {
                    typeName.append("'").append(parameter).append("'");
                    continue;
                }
                typeName.append(parameter.toString());
            }
            typeName.append(")");
        }
        return typeName.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientTypeSignature other = (ClientTypeSignature)o;
        return Objects.equals(this.rawType.toLowerCase(Locale.ENGLISH), other.rawType.toLowerCase(Locale.ENGLISH)) && Objects.equals(this.typeArguments, other.typeArguments) && Objects.equals(this.literalArguments, other.literalArguments);
    }

    public int hashCode() {
        return Objects.hash(this.rawType.toLowerCase(Locale.ENGLISH), this.typeArguments, this.literalArguments);
    }
}

