package com.facebook.presto.jdbc.internal.jackson.datatype.guava.ser;

import java.io.IOException;

import com.facebook.presto.jdbc.internal.jackson.core.JsonGenerationException;
import com.facebook.presto.jdbc.internal.jackson.core.JsonGenerator;
import com.facebook.presto.jdbc.internal.jackson.core.JsonProcessingException;
import com.facebook.presto.jdbc.internal.jackson.databind.JavaType;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonMappingException;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializerProvider;
import com.facebook.presto.jdbc.internal.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.facebook.presto.jdbc.internal.jackson.databind.jsontype.TypeSerializer;
import com.facebook.presto.jdbc.internal.jackson.databind.ser.std.StdSerializer;
import com.facebook.presto.jdbc.internal.guava.base.Optional;

public final class GuavaOptionalSerializer extends StdSerializer<Optional<?>>
{
    public GuavaOptionalSerializer(JavaType type) {
        super(type);
    }

    // implemented since 2.3
    @Override
    public boolean isEmpty(Optional<?> value) {
        return (value == null) || !value.isPresent();
    }

    @Override
    public void serialize(Optional<?> value, JsonGenerator jgen, SerializerProvider provider)
            throws IOException, JsonGenerationException {
        if(value.isPresent()){
            provider.defaultSerializeValue(value.get(), jgen);
        } else{
            provider.defaultSerializeNull(jgen);
        }
    }
    
    @Override
    public void serializeWithType(Optional<?> value,
                                  JsonGenerator jgen,
                                  SerializerProvider provider,
                                  TypeSerializer typeSer) throws IOException, JsonProcessingException {
        serialize(value, jgen, provider);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JavaType typeParameter = typeHint.containedType(0);
        if (typeParameter != null) {
            visitor.getProvider().findValueSerializer(typeParameter, null).acceptJsonFormatVisitor(visitor, typeParameter);
            return;
        }
        super.acceptJsonFormatVisitor(visitor, typeHint);
    }
}