/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc;

import java.util.Objects;

public class PrestoIntervalYearMonth {
    private final long months;

    public PrestoIntervalYearMonth(long months) {
        this.months = months;
    }

    public PrestoIntervalYearMonth(int year, int months) {
        this.months = 12 * year + months;
    }

    public long getMonths() {
        return this.months;
    }

    public int hashCode() {
        return Objects.hash(this.months);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrestoIntervalYearMonth other = (PrestoIntervalYearMonth)obj;
        return Objects.equals(this.months, other.months);
    }

    public String toString() {
        return PrestoIntervalYearMonth.formatMonths(this.months);
    }

    private static String formatMonths(long months) {
        return months / 12L + "-" + months % 12L;
    }
}

