/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.client;

import com.facebook.presto.jdbc.internal.guava.base.MoreObjects;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableMap;
import java.net.URI;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ClientSession {
    private final URI server;
    private final String user;
    private final String source;
    private final String catalog;
    private final String schema;
    private final String timeZoneId;
    private final Locale locale;
    private final Map<String, String> properties;
    private final boolean debug;

    public static ClientSession withCatalogAndSchema(ClientSession session, String catalog, String schema) {
        return new ClientSession(session.getServer(), session.getUser(), session.getSource(), catalog, schema, session.getTimeZoneId(), session.getLocale(), session.getProperties(), session.isDebug());
    }

    public static ClientSession withSessionProperties(ClientSession session, Map<String, String> sessionProperties) {
        HashMap<String, String> properties = new HashMap<String, String>(session.getProperties());
        properties.putAll(sessionProperties);
        return new ClientSession(session.getServer(), session.getUser(), session.getSource(), session.getCatalog(), session.getSchema(), session.getTimeZoneId(), session.getLocale(), properties, session.isDebug());
    }

    public ClientSession(URI server, String user, String source, String catalog, String schema, String timeZoneId, Locale locale, Map<String, String> properties, boolean debug) {
        this.server = Preconditions.checkNotNull(server, "server is null");
        this.user = user;
        this.source = source;
        this.catalog = catalog;
        this.schema = schema;
        this.locale = locale;
        this.timeZoneId = Preconditions.checkNotNull(timeZoneId, "timeZoneId is null");
        this.debug = debug;
        this.properties = ImmutableMap.copyOf(Preconditions.checkNotNull(properties, "options is null"));
        CharsetEncoder charsetEncoder = StandardCharsets.US_ASCII.newEncoder();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            Preconditions.checkArgument(!entry.getKey().isEmpty(), "Session property name is empty");
            Preconditions.checkArgument(entry.getKey().indexOf(61) < 0, "Session property name must not contain '=': %s", entry.getKey());
            Preconditions.checkArgument(charsetEncoder.canEncode(entry.getKey()), "Session property name is not US_ASCII: %s", entry.getKey());
            Preconditions.checkArgument(charsetEncoder.canEncode(entry.getValue()), "Session property value is not US_ASCII: %s", entry.getValue());
        }
    }

    public URI getServer() {
        return this.server;
    }

    public String getUser() {
        return this.user;
    }

    public String getSource() {
        return this.source;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("server", this.server).add("user", this.user).add("catalog", this.catalog).add("schema", this.schema).add("timeZone", this.timeZoneId).add("locale", this.locale).add("properties", this.properties).add("debug", this.debug).toString();
    }
}

