/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonIgnore;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.Marker;
import com.facebook.presto.jdbc.internal.spi.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;

public final class SortedRangeSet
implements Iterable<Range> {
    private final Class<?> type;
    private final NavigableMap<Marker, Range> lowIndexedRanges;

    private SortedRangeSet(Class<?> type, NavigableMap<Marker, Range> lowIndexedRanges) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.lowIndexedRanges = Objects.requireNonNull(lowIndexedRanges, "lowIndexedRanges is null");
    }

    public static SortedRangeSet none(Class<?> type) {
        return SortedRangeSet.copyOf(type, Collections.emptyList());
    }

    public static SortedRangeSet all(Class<?> type) {
        return SortedRangeSet.copyOf(type, Arrays.asList(Range.all(type)));
    }

    public static SortedRangeSet singleValue(Comparable<?> value) {
        return SortedRangeSet.of(Range.equal(value), new Range[0]);
    }

    public static SortedRangeSet of(Range first, Range ... ranges) {
        ArrayList<Range> rangeList = new ArrayList<Range>();
        rangeList.add(first);
        rangeList.addAll(Arrays.asList(ranges));
        return SortedRangeSet.copyOf(first.getType(), rangeList);
    }

    public static SortedRangeSet copyOf(Class<?> type, Iterable<Range> ranges) {
        return new Builder(type).addAll(ranges).build();
    }

    @JsonCreator
    public static SortedRangeSet copyOf(@JsonProperty(value="type") Class<?> type, @JsonProperty(value="ranges") List<Range> ranges) {
        return SortedRangeSet.copyOf(type, ranges);
    }

    @JsonProperty
    public Class<?> getType() {
        return this.type;
    }

    @JsonProperty
    public List<Range> getRanges() {
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.addAll(this.lowIndexedRanges.values());
        return ranges;
    }

    @JsonIgnore
    public int getRangeCount() {
        return this.lowIndexedRanges.size();
    }

    @JsonIgnore
    public boolean isNone() {
        return this.lowIndexedRanges.isEmpty();
    }

    @JsonIgnore
    public boolean isAll() {
        return this.lowIndexedRanges.size() == 1 && ((Range)this.lowIndexedRanges.values().iterator().next()).isAll();
    }

    @JsonIgnore
    public boolean isSingleValue() {
        return this.lowIndexedRanges.size() == 1 && ((Range)this.lowIndexedRanges.values().iterator().next()).isSingleValue();
    }

    @JsonIgnore
    public Comparable<?> getSingleValue() {
        if (!this.isSingleValue()) {
            throw new IllegalStateException("SortedRangeSet does not have just a single value");
        }
        return ((Range)this.lowIndexedRanges.values().iterator().next()).getSingleValue();
    }

    public boolean includesMarker(Marker marker) {
        Objects.requireNonNull(marker, "marker is null");
        this.checkTypeCompatibility(marker);
        Map.Entry<Marker, Range> floorEntry = this.lowIndexedRanges.floorEntry(marker);
        return floorEntry != null && floorEntry.getValue().includes(marker);
    }

    @JsonIgnore
    public Range getSpan() {
        if (this.lowIndexedRanges.isEmpty()) {
            throw new IllegalStateException("Can not get span if no ranges exist");
        }
        return this.lowIndexedRanges.firstEntry().getValue().span(this.lowIndexedRanges.lastEntry().getValue());
    }

    public boolean overlaps(SortedRangeSet other) {
        this.checkTypeCompatibility(other);
        return !this.intersect(other).isNone();
    }

    public boolean contains(SortedRangeSet other) {
        this.checkTypeCompatibility(other);
        return this.union(other).equals(this);
    }

    public SortedRangeSet intersect(SortedRangeSet other) {
        this.checkTypeCompatibility(other);
        Builder builder = new Builder(this.type);
        Iterator<Range> iter1 = this.iterator();
        Iterator<Range> iter2 = other.iterator();
        if (iter1.hasNext() && iter2.hasNext()) {
            Range range1 = iter1.next();
            Range range2 = iter2.next();
            while (true) {
                if (range1.overlaps(range2)) {
                    builder.add(range1.intersect(range2));
                }
                if (range1.getHigh().compareTo(range2.getHigh()) <= 0) {
                    if (!iter1.hasNext()) break;
                    range1 = iter1.next();
                    continue;
                }
                if (!iter2.hasNext()) break;
                range2 = iter2.next();
            }
        }
        return builder.build();
    }

    public SortedRangeSet union(SortedRangeSet other) {
        this.checkTypeCompatibility(other);
        return new Builder(this.type).addAll(this).addAll(other).build();
    }

    public static SortedRangeSet union(Iterable<SortedRangeSet> ranges) {
        Iterator<SortedRangeSet> iterator = ranges.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("ranges must have at least one element");
        }
        SortedRangeSet first = iterator.next();
        Builder builder = new Builder(first.type);
        builder.addAll(first);
        while (iterator.hasNext()) {
            builder.addAll(iterator.next());
        }
        return builder.build();
    }

    public SortedRangeSet complement() {
        Builder builder = new Builder(this.type);
        if (this.lowIndexedRanges.isEmpty()) {
            return builder.add(Range.all(this.type)).build();
        }
        Iterator rangeIterator = this.lowIndexedRanges.values().iterator();
        Range firstRange = (Range)rangeIterator.next();
        if (!firstRange.getLow().isLowerUnbounded()) {
            builder.add(new Range(Marker.lowerUnbounded(this.type), firstRange.getLow().lesserAdjacent()));
        }
        Range previousRange = firstRange;
        while (rangeIterator.hasNext()) {
            Range currentRange = (Range)rangeIterator.next();
            Marker lowMarker = previousRange.getHigh().greaterAdjacent();
            Marker highMarker = currentRange.getLow().lesserAdjacent();
            builder.add(new Range(lowMarker, highMarker));
            previousRange = currentRange;
        }
        Range lastRange = previousRange;
        if (!lastRange.getHigh().isUpperUnbounded()) {
            builder.add(new Range(lastRange.getHigh().greaterAdjacent(), Marker.upperUnbounded(this.type)));
        }
        return builder.build();
    }

    public SortedRangeSet subtract(SortedRangeSet other) {
        this.checkTypeCompatibility(other);
        return this.intersect(other.complement());
    }

    private void checkTypeCompatibility(SortedRangeSet other) {
        if (!this.getType().equals(other.getType())) {
            throw new IllegalStateException(String.format("Mismatched SortedRangeSet types: %s vs %s", this.getType(), other.getType()));
        }
    }

    private void checkTypeCompatibility(Marker marker) {
        if (!this.getType().equals(marker.getType())) {
            throw new IllegalStateException(String.format("Marker of %s does not match SortedRangeSet of %s", marker.getType(), this.getType()));
        }
    }

    @Override
    public Iterator<Range> iterator() {
        return Collections.unmodifiableCollection(this.lowIndexedRanges.values()).iterator();
    }

    public int hashCode() {
        return Objects.hash(this.lowIndexedRanges);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SortedRangeSet other = (SortedRangeSet)obj;
        return Objects.equals(this.lowIndexedRanges, other.lowIndexedRanges);
    }

    public String toString() {
        return this.lowIndexedRanges.values().toString();
    }

    public static Builder builder(Class<?> type) {
        return new Builder(type);
    }

    public static class Builder {
        private static final Comparator<Range> LOW_MARKER_COMPARATOR = new Comparator<Range>(){

            @Override
            public int compare(Range o1, Range o2) {
                return o1.getLow().compareTo(o2.getLow());
            }
        };
        private final Class<?> type;
        private final List<Range> ranges = new ArrayList<Range>();

        public Builder(Class<?> type) {
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public Builder add(Range range) {
            if (!this.type.equals(range.getType())) {
                throw new IllegalArgumentException(String.format("Range type %s does not match builder type %s", range.getType(), this.type));
            }
            this.ranges.add(range);
            return this;
        }

        public Builder addAll(Iterable<Range> ranges) {
            for (Range range : ranges) {
                this.add(range);
            }
            return this;
        }

        public SortedRangeSet build() {
            Collections.sort(this.ranges, LOW_MARKER_COMPARATOR);
            TreeMap<Marker, Range> result = new TreeMap<Marker, Range>();
            Range current = null;
            for (Range next : this.ranges) {
                if (current == null) {
                    current = next;
                    continue;
                }
                if (current.overlaps(next) || current.getHigh().isAdjacent(next.getLow())) {
                    current = current.span(next);
                    continue;
                }
                result.put(current.getLow(), current);
                current = next;
            }
            if (current != null) {
                result.put(current.getLow(), current);
            }
            return new SortedRangeSet(this.type, result);
        }
    }
}

