/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.client;

import com.facebook.presto.jdbc.internal.airlift.http.client.FullJsonResponseHandler;
import com.facebook.presto.jdbc.internal.airlift.http.client.HttpClient;
import com.facebook.presto.jdbc.internal.airlift.http.client.HttpStatus;
import com.facebook.presto.jdbc.internal.airlift.http.client.HttpUriBuilder;
import com.facebook.presto.jdbc.internal.airlift.http.client.Request;
import com.facebook.presto.jdbc.internal.airlift.http.client.StaticBodyGenerator;
import com.facebook.presto.jdbc.internal.airlift.http.client.StatusResponseHandler;
import com.facebook.presto.jdbc.internal.airlift.json.JsonCodec;
import com.facebook.presto.jdbc.internal.client.ClientSession;
import com.facebook.presto.jdbc.internal.client.QueryResults;
import com.facebook.presto.jdbc.internal.guava.base.Objects;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.base.Splitter;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableMap;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableSet;
import com.facebook.presto.jdbc.internal.guava.collect.Sets;
import com.facebook.presto.jdbc.internal.guava.util.concurrent.Uninterruptibles;
import java.io.Closeable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class StatementClient
implements Closeable {
    private static final Splitter SESSION_HEADER_SPLITTER = Splitter.on('=').limit(2).trimResults();
    private static final String USER_AGENT_VALUE = StatementClient.class.getSimpleName() + "/" + Objects.firstNonNull(StatementClient.class.getPackage().getImplementationVersion(), "unknown");
    private final HttpClient httpClient;
    private final FullJsonResponseHandler<QueryResults> responseHandler;
    private final boolean debug;
    private final String query;
    private final AtomicReference<QueryResults> currentResults = new AtomicReference();
    private final Map<String, String> setSessionProperties = new ConcurrentHashMap<String, String>();
    private final Set<String> resetSessionProperties = Sets.newConcurrentHashSet();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean gone = new AtomicBoolean();
    private final AtomicBoolean valid = new AtomicBoolean(true);
    private final String timeZoneId;

    public StatementClient(HttpClient httpClient, JsonCodec<QueryResults> queryResultsCodec, ClientSession session, String query) {
        Preconditions.checkNotNull(httpClient, "httpClient is null");
        Preconditions.checkNotNull(queryResultsCodec, "queryResultsCodec is null");
        Preconditions.checkNotNull(session, "session is null");
        Preconditions.checkNotNull(query, "query is null");
        this.httpClient = httpClient;
        this.responseHandler = FullJsonResponseHandler.createFullJsonResponseHandler(queryResultsCodec);
        this.debug = session.isDebug();
        this.timeZoneId = session.getTimeZoneId();
        this.query = query;
        Request request = StatementClient.buildQueryRequest(session, query);
        FullJsonResponseHandler.JsonResponse response = (FullJsonResponseHandler.JsonResponse)httpClient.execute(request, this.responseHandler);
        if (response.getStatusCode() != HttpStatus.OK.code() || !response.hasValue()) {
            throw this.requestFailedException("starting query", request, response);
        }
        this.processResponse(response);
    }

    private static Request buildQueryRequest(ClientSession session, String query) {
        Request.Builder builder = Request.Builder.preparePost().setUri(HttpUriBuilder.uriBuilderFrom(session.getServer()).replacePath("/v1/statement").build()).setBodyGenerator(StaticBodyGenerator.createStaticBodyGenerator(query, StandardCharsets.UTF_8));
        if (session.getUser() != null) {
            builder.setHeader("X-Presto-User", session.getUser());
        }
        if (session.getSource() != null) {
            builder.setHeader("X-Presto-Source", session.getSource());
        }
        if (session.getCatalog() != null) {
            builder.setHeader("X-Presto-Catalog", session.getCatalog());
        }
        if (session.getSchema() != null) {
            builder.setHeader("X-Presto-Schema", session.getSchema());
        }
        builder.setHeader("X-Presto-Time-Zone", session.getTimeZoneId());
        builder.setHeader("X-Presto-Language", session.getLocale().toLanguageTag());
        builder.setHeader("User-Agent", USER_AGENT_VALUE);
        Map<String, String> property = session.getProperties();
        for (Map.Entry<String, String> entry : property.entrySet()) {
            builder.addHeader("X-Presto-Session", entry.getKey() + "=" + entry.getValue());
        }
        return builder.build();
    }

    public String getQuery() {
        return this.query;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isGone() {
        return this.gone.get();
    }

    public boolean isFailed() {
        return this.currentResults.get().getError() != null;
    }

    public QueryResults current() {
        Preconditions.checkState(this.isValid(), "current position is not valid (cursor past end)");
        return this.currentResults.get();
    }

    public QueryResults finalResults() {
        Preconditions.checkState(!this.isValid() || this.isFailed(), "current position is still valid");
        return this.currentResults.get();
    }

    public Map<String, String> getSetSessionProperties() {
        return ImmutableMap.copyOf(this.setSessionProperties);
    }

    public Set<String> getResetSessionProperties() {
        return ImmutableSet.copyOf(this.resetSessionProperties);
    }

    public boolean isValid() {
        return this.valid.get() && !this.isGone() && !this.isClosed();
    }

    public boolean advance() {
        if (this.isClosed() || this.current().getNextUri() == null) {
            this.valid.set(false);
            return false;
        }
        Request request = Request.Builder.prepareGet().setHeader("User-Agent", USER_AGENT_VALUE).setUri(this.current().getNextUri()).build();
        RuntimeException cause = null;
        long start = System.nanoTime();
        long attempts = 0L;
        do {
            FullJsonResponseHandler.JsonResponse response;
            if (attempts > 0L) {
                Uninterruptibles.sleepUninterruptibly(attempts * 100L, TimeUnit.MILLISECONDS);
            }
            ++attempts;
            try {
                response = (FullJsonResponseHandler.JsonResponse)this.httpClient.execute(request, this.responseHandler);
            }
            catch (RuntimeException e) {
                cause = e;
                continue;
            }
            if (response.getStatusCode() == HttpStatus.OK.code() && response.hasValue()) {
                this.processResponse(response);
                return true;
            }
            if (response.getStatusCode() == HttpStatus.SERVICE_UNAVAILABLE.code()) continue;
            throw this.requestFailedException("fetching next", request, response);
        } while (System.nanoTime() - start < TimeUnit.MINUTES.toNanos(2L) && !this.isClosed());
        this.gone.set(true);
        throw new RuntimeException("Error fetching next", cause);
    }

    private void processResponse(FullJsonResponseHandler.JsonResponse<QueryResults> response) {
        for (String setSession : response.getHeaders().get("X-Presto-Set-Session")) {
            List<String> keyValue = SESSION_HEADER_SPLITTER.splitToList(setSession);
            if (keyValue.size() != 2) continue;
            this.setSessionProperties.put(keyValue.get(0), keyValue.size() > 1 ? keyValue.get(1) : "");
        }
        for (String clearSession : response.getHeaders().get("X-Presto-Clear-Session")) {
            this.resetSessionProperties.add(clearSession);
        }
        this.currentResults.set(response.getValue());
    }

    private RuntimeException requestFailedException(String task, Request request, FullJsonResponseHandler.JsonResponse<QueryResults> response) {
        this.gone.set(true);
        if (!response.hasValue()) {
            return new RuntimeException(String.format("Error " + task + " at %s returned an invalid response: %s", request.getUri(), response), response.getException());
        }
        return new RuntimeException(String.format("Error " + task + " at %s returned %s: %s", request.getUri(), response.getStatusCode(), response.getStatusMessage()));
    }

    public boolean cancelLeafStage() {
        Preconditions.checkState(!this.isClosed(), "client is closed");
        URI uri = this.current().getPartialCancelUri();
        if (uri == null) {
            return false;
        }
        Request request = Request.Builder.prepareDelete().setHeader("User-Agent", USER_AGENT_VALUE).setUri(uri).build();
        StatusResponseHandler.StatusResponse status = this.httpClient.execute(request, StatusResponseHandler.createStatusResponseHandler());
        return HttpStatus.familyForStatusCode(status.getStatusCode()) == HttpStatus.Family.SUCCESSFUL;
    }

    @Override
    public void close() {
        URI uri;
        if (!this.closed.getAndSet(true) && (uri = this.currentResults.get().getNextUri()) != null) {
            Request request = Request.Builder.prepareDelete().setHeader("User-Agent", USER_AGENT_VALUE).setUri(uri).build();
            this.httpClient.executeAsync(request, StatusResponseHandler.createStatusResponseHandler());
        }
    }
}

