/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client;

import com.facebook.presto.jdbc.internal.jetty.client.api.Request;
import com.facebook.presto.jdbc.internal.jetty.client.api.Response;
import com.facebook.presto.jdbc.internal.jetty.client.api.Result;
import com.facebook.presto.jdbc.internal.jetty.util.log.Log;
import com.facebook.presto.jdbc.internal.jetty.util.log.Logger;
import com.facebook.presto.jdbc.internal.jetty.util.thread.Scheduler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class TimeoutCompleteListener
implements Response.CompleteListener,
Runnable {
    private static final Logger LOG = Log.getLogger(TimeoutCompleteListener.class);
    private final AtomicReference<Scheduler.Task> task = new AtomicReference();
    private final Request request;

    public TimeoutCompleteListener(Request request) {
        this.request = request;
    }

    @Override
    public void onComplete(Result result) {
        Scheduler.Task task = this.task.getAndSet(null);
        if (task != null) {
            boolean cancelled = task.cancel();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cancelled (successfully: {}) timeout task {}", cancelled, task);
            }
        }
    }

    public boolean schedule(Scheduler scheduler) {
        long timeout = this.request.getTimeout();
        Scheduler.Task task = scheduler.schedule(this, timeout, TimeUnit.MILLISECONDS);
        if (this.task.getAndSet(task) != null) {
            throw new IllegalStateException();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scheduled timeout task {} in {} ms for {}", task, timeout, this.request);
        }
        return true;
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing timeout task {} for {}", this.task, this.request);
        }
        this.request.abort(new TimeoutException("Total timeout elapsed"));
    }
}

