/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client.jetty;

import com.facebook.presto.jdbc.internal.airlift.http.client.BodyGenerator;
import com.facebook.presto.jdbc.internal.airlift.http.client.HttpClient;
import com.facebook.presto.jdbc.internal.airlift.http.client.HttpClientConfig;
import com.facebook.presto.jdbc.internal.airlift.http.client.HttpRequestFilter;
import com.facebook.presto.jdbc.internal.airlift.http.client.Request;
import com.facebook.presto.jdbc.internal.airlift.http.client.RequestStats;
import com.facebook.presto.jdbc.internal.airlift.http.client.Response;
import com.facebook.presto.jdbc.internal.airlift.http.client.ResponseHandler;
import com.facebook.presto.jdbc.internal.airlift.http.client.ResponseTooLargeException;
import com.facebook.presto.jdbc.internal.airlift.http.client.StaticBodyGenerator;
import com.facebook.presto.jdbc.internal.airlift.http.client.jetty.JettyIoPool;
import com.facebook.presto.jdbc.internal.airlift.http.client.jetty.JettyIoPoolConfig;
import com.facebook.presto.jdbc.internal.airlift.log.Logger;
import com.facebook.presto.jdbc.internal.airlift.stats.Distribution;
import com.facebook.presto.jdbc.internal.airlift.units.DataSize;
import com.facebook.presto.jdbc.internal.airlift.units.Duration;
import com.facebook.presto.jdbc.internal.guava.base.MoreObjects;
import com.facebook.presto.jdbc.internal.guava.base.Optional;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.base.Throwables;
import com.facebook.presto.jdbc.internal.guava.collect.AbstractIterator;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableList;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableListMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.ListMultimap;
import com.facebook.presto.jdbc.internal.guava.io.CountingInputStream;
import com.facebook.presto.jdbc.internal.guava.net.HostAndPort;
import com.facebook.presto.jdbc.internal.guava.primitives.Ints;
import com.facebook.presto.jdbc.internal.guava.util.concurrent.AbstractFuture;
import com.facebook.presto.jdbc.internal.jetty.client.HttpRequest;
import com.facebook.presto.jdbc.internal.jetty.client.PoolingHttpDestination;
import com.facebook.presto.jdbc.internal.jetty.client.Socks4Proxy;
import com.facebook.presto.jdbc.internal.jetty.client.api.ContentProvider;
import com.facebook.presto.jdbc.internal.jetty.client.api.Destination;
import com.facebook.presto.jdbc.internal.jetty.client.api.Response;
import com.facebook.presto.jdbc.internal.jetty.client.api.Result;
import com.facebook.presto.jdbc.internal.jetty.client.util.BytesContentProvider;
import com.facebook.presto.jdbc.internal.jetty.client.util.InputStreamResponseListener;
import com.facebook.presto.jdbc.internal.jetty.http.HttpFields;
import com.facebook.presto.jdbc.internal.jetty.http.HttpHeader;
import com.facebook.presto.jdbc.internal.jetty.util.HttpCookieStore;
import com.facebook.presto.jdbc.internal.jetty.util.ssl.SslContextFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class JettyHttpClient
implements HttpClient {
    private static final AtomicLong nameCounter = new AtomicLong();
    private final com.facebook.presto.jdbc.internal.jetty.client.HttpClient httpClient;
    private final long maxContentLength;
    private final RequestStats stats = new RequestStats();
    private final QueueDistribution queuedRequestsPerDestination;
    private final List<HttpRequestFilter> requestFilters;
    private final Exception creationLocation = new Exception();
    private final String name;

    public JettyHttpClient() {
        this(new HttpClientConfig(), ImmutableList.of());
    }

    public JettyHttpClient(HttpClientConfig config) {
        this(config, ImmutableList.of());
    }

    public JettyHttpClient(HttpClientConfig config, Iterable<? extends HttpRequestFilter> requestFilters) {
        this(config, Optional.absent(), requestFilters);
    }

    public JettyHttpClient(HttpClientConfig config, JettyIoPool jettyIoPool, Iterable<? extends HttpRequestFilter> requestFilters) {
        this(config, Optional.of(jettyIoPool), requestFilters);
    }

    private JettyHttpClient(HttpClientConfig config, Optional<JettyIoPool> jettyIoPool, Iterable<? extends HttpRequestFilter> requestFilters) {
        Preconditions.checkNotNull(config, "config is null");
        Preconditions.checkNotNull(jettyIoPool, "jettyIoPool is null");
        Preconditions.checkNotNull(requestFilters, "requestFilters is null");
        this.maxContentLength = config.getMaxContentLength().toBytes();
        this.httpClient = this.createHttpClient(config, this.creationLocation);
        JettyIoPool pool = jettyIoPool.orNull();
        if (pool == null) {
            pool = new JettyIoPool("anonymous" + nameCounter.incrementAndGet(), new JettyIoPoolConfig());
        }
        this.name = pool.getName();
        this.httpClient.setExecutor(pool.getExecutor());
        this.httpClient.setByteBufferPool(pool.setByteBufferPool());
        this.httpClient.setScheduler(pool.setScheduler());
        try {
            this.httpClient.start();
            this.httpClient.getContentDecoderFactories().clear();
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw Throwables.propagate(e);
        }
        this.requestFilters = ImmutableList.copyOf(requestFilters);
        this.queuedRequestsPerDestination = new QueueDistribution(this.httpClient);
    }

    private com.facebook.presto.jdbc.internal.jetty.client.HttpClient createHttpClient(HttpClientConfig config, Exception created) {
        HostAndPort socksProxy;
        created.fillInStackTrace();
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setEndpointIdentificationAlgorithm("HTTPS");
        if (config.getKeyStorePath() != null) {
            sslContextFactory.setKeyStorePath(config.getKeyStorePath());
            sslContextFactory.setKeyStorePassword(config.getKeyStorePassword());
        }
        com.facebook.presto.jdbc.internal.jetty.client.HttpClient httpClient = new com.facebook.presto.jdbc.internal.jetty.client.HttpClient(sslContextFactory);
        httpClient.setMaxConnectionsPerDestination(config.getMaxConnectionsPerServer());
        httpClient.setMaxRequestsQueuedPerDestination(config.getMaxRequestsQueuedPerDestination());
        httpClient.setCookieStore(new HttpCookieStore.Empty());
        long idleTimeout = Long.MAX_VALUE;
        if (config.getKeepAliveInterval() != null) {
            idleTimeout = Math.min(idleTimeout, config.getKeepAliveInterval().toMillis());
        }
        if (config.getReadTimeout() != null) {
            idleTimeout = Math.min(idleTimeout, config.getReadTimeout().toMillis());
        }
        if (idleTimeout != Long.MAX_VALUE) {
            httpClient.setIdleTimeout(idleTimeout);
        }
        if (config.getConnectTimeout() != null) {
            long connectTimeout = config.getConnectTimeout().toMillis();
            httpClient.setConnectTimeout(connectTimeout);
            httpClient.setAddressResolutionTimeout(connectTimeout);
        }
        if ((socksProxy = config.getSocksProxy()) != null) {
            httpClient.getProxyConfiguration().getProxies().add(new Socks4Proxy(socksProxy.getHostText(), socksProxy.getPortOrDefault(1080)));
        }
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Exception> T execute(Request request, ResponseHandler<T, E> responseHandler) throws E {
        T value;
        com.facebook.presto.jdbc.internal.jetty.client.api.Response response;
        long requestStart = System.nanoTime();
        request = this.applyRequestFilters(request);
        HttpRequest jettyRequest = this.buildJettyRequest(request);
        InputStreamResponseListener listener = new InputStreamResponseListener(this.maxContentLength){

            @Override
            public void onContent(com.facebook.presto.jdbc.internal.jetty.client.api.Response response, ByteBuffer content) {
                if (content.remaining() == 0) {
                    return;
                }
                super.onContent(response, content);
            }
        };
        jettyRequest.send(listener);
        try {
            response = listener.get(this.httpClient.getIdleTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return responseHandler.handleException(request, e);
        }
        catch (TimeoutException e) {
            return responseHandler.handleException(request, e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                return responseHandler.handleException(request, (Exception)cause);
            }
            return responseHandler.handleException(request, new RuntimeException(cause));
        }
        long responseStart = System.nanoTime();
        JettyResponse jettyResponse = null;
        try {
            jettyResponse = new JettyResponse(response, listener.getInputStream());
            value = responseHandler.handle(request, jettyResponse);
        }
        finally {
            JettyHttpClient.recordRequestComplete(this.stats, request, requestStart, jettyResponse, responseStart);
        }
        return value;
    }

    @Override
    public <T, E extends Exception> HttpClient.HttpResponseFuture<T> executeAsync(Request request, ResponseHandler<T, E> responseHandler) {
        Preconditions.checkNotNull(request, "request is null");
        Preconditions.checkNotNull(responseHandler, "responseHandler is null");
        request = this.applyRequestFilters(request);
        HttpRequest jettyRequest = this.buildJettyRequest(request);
        JettyResponseFuture<T, E> future = new JettyResponseFuture<T, E>(request, jettyRequest, responseHandler, this.stats);
        BufferingResponseListener listener = new BufferingResponseListener(future, Ints.saturatedCast(this.maxContentLength));
        try {
            jettyRequest.send(listener);
        }
        catch (RuntimeException e) {
            future.failed(e);
        }
        return future;
    }

    private Request applyRequestFilters(Request request) {
        for (HttpRequestFilter requestFilter : this.requestFilters) {
            request = requestFilter.filterRequest(request);
        }
        return request;
    }

    private HttpRequest buildJettyRequest(Request finalRequest) {
        HttpRequest jettyRequest = (HttpRequest)this.httpClient.newRequest(finalRequest.getUri());
        jettyRequest.getHeaders().remove(HttpHeader.USER_AGENT);
        jettyRequest.method(finalRequest.getMethod());
        for (Map.Entry entry : finalRequest.getHeaders().entries()) {
            jettyRequest.header((String)entry.getKey(), (String)entry.getValue());
        }
        BodyGenerator bodyGenerator = finalRequest.getBodyGenerator();
        if (bodyGenerator != null) {
            if (bodyGenerator instanceof StaticBodyGenerator) {
                StaticBodyGenerator staticBodyGenerator = (StaticBodyGenerator)bodyGenerator;
                jettyRequest.content(new BytesContentProvider(new byte[][]{staticBodyGenerator.getBody()}));
            } else {
                jettyRequest.content(new BodyGeneratorContentProvider(bodyGenerator, this.httpClient.getExecutor()));
            }
        }
        return jettyRequest;
    }

    public List<HttpRequestFilter> getRequestFilters() {
        return this.requestFilters;
    }

    @Override
    @Managed
    @Flatten
    public RequestStats getStats() {
        return this.stats;
    }

    @Managed
    @Nested
    public QueueDistribution getQueuedRequestsPerDestination() {
        return this.queuedRequestsPerDestination;
    }

    @Managed
    public String dump() {
        return this.httpClient.dump();
    }

    @Managed
    public void dumpStdErr() {
        this.httpClient.dumpStdErr();
    }

    @Override
    public void close() {
        try {
            this.httpClient.stop();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.name).toString();
    }

    public StackTraceElement[] getCreationLocation() {
        return this.creationLocation.getStackTrace();
    }

    private static void recordRequestComplete(RequestStats requestStats, Request request, long requestStart, JettyResponse response, long responseStart) {
        if (response == null) {
            return;
        }
        Duration responseProcessingTime = Duration.nanosSince(responseStart);
        Duration requestProcessingTime = new Duration(responseStart - requestStart, TimeUnit.NANOSECONDS);
        requestStats.record(request.getMethod(), response.getStatusCode(), response.getBytesRead(), response.getBytesRead(), requestProcessingTime, responseProcessingTime);
    }

    @ThreadSafe
    public static class QueueDistribution {
        private final com.facebook.presto.jdbc.internal.jetty.client.HttpClient httpClient;
        @GuardedBy(value="this")
        private Distribution distribution;
        @GuardedBy(value="this")
        private long lastUpdate = System.nanoTime();

        public QueueDistribution(com.facebook.presto.jdbc.internal.jetty.client.HttpClient httpClient) {
            this.httpClient = httpClient;
        }

        public synchronized Distribution getDistribution() {
            if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.lastUpdate) > 1000L) {
                this.distribution = new Distribution();
                for (Destination destination : this.httpClient.getDestinations()) {
                    PoolingHttpDestination poolingHttpDestination = (PoolingHttpDestination)destination;
                    this.distribution.add(poolingHttpDestination.getHttpExchanges().size());
                }
                this.lastUpdate = System.nanoTime();
            }
            return this.distribution;
        }

        @Managed
        public double getMaxError() {
            return this.getDistribution().getMaxError();
        }

        @Managed
        public double getCount() {
            return this.getDistribution().getCount();
        }

        @Managed
        public double getTotal() {
            return this.getDistribution().getTotal();
        }

        @Managed
        public long getP01() {
            return this.getDistribution().getP01();
        }

        @Managed
        public long getP05() {
            return this.getDistribution().getP05();
        }

        @Managed
        public long getP10() {
            return this.getDistribution().getP10();
        }

        @Managed
        public long getP25() {
            return this.getDistribution().getP25();
        }

        @Managed
        public long getP50() {
            return this.getDistribution().getP50();
        }

        @Managed
        public long getP75() {
            return this.getDistribution().getP75();
        }

        @Managed
        public long getP90() {
            return this.getDistribution().getP90();
        }

        @Managed
        public long getP95() {
            return this.getDistribution().getP95();
        }

        @Managed
        public long getP99() {
            return this.getDistribution().getP99();
        }

        @Managed
        public long getMin() {
            return this.getDistribution().getMin();
        }

        @Managed
        public long getMax() {
            return this.getDistribution().getMax();
        }

        @Managed
        public Map<Double, Long> getPercentiles() {
            return this.getDistribution().getPercentiles();
        }
    }

    private static class BufferingResponseListener
    extends Response.Listener.Adapter {
        private final JettyResponseFuture<?, ?> future;
        private final int maxLength;
        @GuardedBy(value="this")
        private byte[] buffer = new byte[(int)new DataSize(64.0, DataSize.Unit.KILOBYTE).toBytes()];
        @GuardedBy(value="this")
        private int size;

        public BufferingResponseListener(JettyResponseFuture<?, ?> future, int maxLength) {
            this.future = Preconditions.checkNotNull(future, "future is null");
            Preconditions.checkArgument(maxLength > 0, "maxLength must be greater than zero");
            this.maxLength = maxLength;
        }

        @Override
        public synchronized void onHeaders(com.facebook.presto.jdbc.internal.jetty.client.api.Response response) {
            long length = response.getHeaders().getLongField(HttpHeader.CONTENT_LENGTH.asString());
            if (length > (long)this.maxLength) {
                response.abort(new ResponseTooLargeException());
            }
            if (length > (long)this.buffer.length) {
                this.buffer = Arrays.copyOf(this.buffer, Ints.saturatedCast(length));
            }
        }

        @Override
        public synchronized void onContent(com.facebook.presto.jdbc.internal.jetty.client.api.Response response, ByteBuffer content) {
            int length = content.remaining();
            int requiredCapacity = this.size + length;
            if (requiredCapacity > this.buffer.length) {
                if (requiredCapacity > this.maxLength) {
                    response.abort(new ResponseTooLargeException());
                    return;
                }
                int newCapacity = Math.min(Integer.highestOneBit(requiredCapacity) << 1, this.maxLength);
                this.buffer = Arrays.copyOf(this.buffer, newCapacity);
            }
            content.get(this.buffer, this.size, length);
            this.size += length;
        }

        @Override
        public synchronized void onComplete(Result result) {
            Throwable throwable = result.getFailure();
            if (throwable != null) {
                this.future.failed(throwable);
            } else {
                this.future.completed(result.getResponse(), new ByteArrayInputStream(this.buffer, 0, this.size));
            }
        }
    }

    private static class BodyGeneratorContentProvider
    implements ContentProvider {
        private static final ByteBuffer DONE = ByteBuffer.allocate(0);
        private static final ByteBuffer EXCEPTION = ByteBuffer.allocate(0);
        private final BodyGenerator bodyGenerator;
        private final Executor executor;

        public BodyGeneratorContentProvider(BodyGenerator bodyGenerator, Executor executor) {
            this.bodyGenerator = bodyGenerator;
            this.executor = executor;
        }

        @Override
        public long getLength() {
            return -1L;
        }

        @Override
        public Iterator<ByteBuffer> iterator() {
            final ArrayBlockingQueue chunks = new ArrayBlockingQueue(16);
            final AtomicReference exception = new AtomicReference();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    BodyGeneratorOutputStream out = new BodyGeneratorOutputStream(chunks);
                    try {
                        bodyGenerator.write(out);
                        out.close();
                    }
                    catch (Exception e) {
                        exception.set(e);
                        chunks.add(EXCEPTION);
                    }
                }
            });
            return new AbstractIterator<ByteBuffer>(){

                @Override
                protected ByteBuffer computeNext() {
                    ByteBuffer chunk;
                    try {
                        chunk = (ByteBuffer)chunks.take();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException("Interrupted", e);
                    }
                    if (chunk == EXCEPTION) {
                        throw Throwables.propagate((Throwable)exception.get());
                    }
                    if (chunk == DONE) {
                        return (ByteBuffer)this.endOfData();
                    }
                    return chunk;
                }
            };
        }

        private final class BodyGeneratorOutputStream
        extends OutputStream {
            private final BlockingQueue<ByteBuffer> chunks;

            private BodyGeneratorOutputStream(BlockingQueue<ByteBuffer> chunks) {
                this.chunks = chunks;
            }

            @Override
            public void write(int b) throws IOException {
                try {
                    this.chunks.put(ByteBuffer.wrap(new byte[]{(byte)b}));
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                try {
                    byte[] copy = Arrays.copyOfRange(b, off, len);
                    this.chunks.put(ByteBuffer.wrap(copy));
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }

            @Override
            public void close() throws IOException {
                try {
                    this.chunks.put(DONE);
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
        }
    }

    private static class JettyResponseFuture<T, E extends Exception>
    extends AbstractFuture<T>
    implements HttpClient.HttpResponseFuture<T> {
        private static final Logger log = Logger.get(JettyResponseFuture.class);
        private final long requestStart = System.nanoTime();
        private final AtomicReference<JettyAsyncHttpState> state = new AtomicReference<JettyAsyncHttpState>(JettyAsyncHttpState.WAITING_FOR_CONNECTION);
        private final Request request;
        private final com.facebook.presto.jdbc.internal.jetty.client.api.Request jettyRequest;
        private final ResponseHandler<T, E> responseHandler;
        private final RequestStats stats;

        public JettyResponseFuture(Request request, com.facebook.presto.jdbc.internal.jetty.client.api.Request jettyRequest, ResponseHandler<T, E> responseHandler, RequestStats stats) {
            this.request = request;
            this.jettyRequest = jettyRequest;
            this.responseHandler = responseHandler;
            this.stats = stats;
        }

        @Override
        public String getState() {
            return this.state.get().toString();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.state.set(JettyAsyncHttpState.CANCELED);
            this.jettyRequest.abort(new CancellationException());
            return super.cancel(mayInterruptIfRunning);
        }

        protected void completed(com.facebook.presto.jdbc.internal.jetty.client.api.Response response, InputStream content) {
            T value;
            if (this.state.get() == JettyAsyncHttpState.CANCELED) {
                return;
            }
            try {
                value = this.processResponse(response, content);
            }
            catch (Throwable e) {
                this.storeException(e);
                return;
            }
            this.state.set(JettyAsyncHttpState.DONE);
            this.set(value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private T processResponse(com.facebook.presto.jdbc.internal.jetty.client.api.Response response, InputStream content) throws E {
            T value;
            long responseStart = System.nanoTime();
            this.state.set(JettyAsyncHttpState.PROCESSING_RESPONSE);
            JettyResponse jettyResponse = null;
            try {
                jettyResponse = new JettyResponse(response, content);
                value = this.responseHandler.handle(this.request, jettyResponse);
            }
            finally {
                JettyHttpClient.recordRequestComplete(this.stats, this.request, this.requestStart, jettyResponse, responseStart);
            }
            return value;
        }

        protected void failed(Throwable throwable) {
            if (this.state.get() == JettyAsyncHttpState.CANCELED) {
                return;
            }
            if (throwable instanceof Exception) {
                try {
                    T value = this.responseHandler.handleException(this.request, (Exception)throwable);
                    this.state.set(JettyAsyncHttpState.DONE);
                    this.set(value);
                    return;
                }
                catch (Throwable newThrowable) {
                    throwable = newThrowable;
                }
            }
            this.storeException(throwable);
        }

        private void storeException(Throwable throwable) {
            if (throwable instanceof CancellationException) {
                this.state.set(JettyAsyncHttpState.CANCELED);
            } else {
                this.state.set(JettyAsyncHttpState.FAILED);
            }
            if (throwable == null) {
                throwable = new Throwable("Throwable is null");
                log.error(throwable, "Something is broken");
            }
            this.setException(throwable);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("requestStart", this.requestStart).add("state", this.state).add("request", this.request).toString();
        }

        public static enum JettyAsyncHttpState {
            WAITING_FOR_CONNECTION,
            SENDING_REQUEST,
            WAITING_FOR_RESPONSE,
            PROCESSING_RESPONSE,
            DONE,
            FAILED,
            CANCELED;

        }
    }

    private static class JettyResponse
    implements Response {
        private final com.facebook.presto.jdbc.internal.jetty.client.api.Response response;
        private final CountingInputStream inputStream;

        public JettyResponse(com.facebook.presto.jdbc.internal.jetty.client.api.Response response, InputStream inputStream) {
            this.response = response;
            this.inputStream = new CountingInputStream(inputStream);
        }

        @Override
        public int getStatusCode() {
            return this.response.getStatus();
        }

        @Override
        public String getStatusMessage() {
            return this.response.getReason();
        }

        @Override
        public String getHeader(String name) {
            return this.response.getHeaders().getStringField(name);
        }

        @Override
        public ListMultimap<String, String> getHeaders() {
            HttpFields headers = this.response.getHeaders();
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            for (String name : headers.getFieldNamesCollection()) {
                for (String value : headers.getValuesList(name)) {
                    builder.put(name, value);
                }
            }
            return builder.build();
        }

        @Override
        public long getBytesRead() {
            return this.inputStream.getCount();
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("statusCode", this.getStatusCode()).add("statusMessage", this.getStatusMessage()).add("headers", this.getHeaders()).toString();
        }
    }
}

