/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.jsr310.deser;

import com.facebook.presto.jdbc.internal.jackson.core.JsonParser;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationContext;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationFeature;
import com.facebook.presto.jdbc.internal.jackson.datatype.jsr310.DecimalUtils;
import com.facebook.presto.jdbc.internal.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Duration;

public class DurationDeserializer
extends JSR310DeserializerBase<Duration> {
    private static final long serialVersionUID = 1L;
    public static final DurationDeserializer INSTANCE = new DurationDeserializer();

    private DurationDeserializer() {
        super(Duration.class);
    }

    @Override
    public Duration deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        switch (parser.getCurrentToken()) {
            case VALUE_NUMBER_FLOAT: {
                BigDecimal value = parser.getDecimalValue();
                long seconds = value.longValue();
                int nanoseconds = DecimalUtils.extractNanosecondDecimal(value, seconds);
                return Duration.ofSeconds(seconds, nanoseconds);
            }
            case VALUE_NUMBER_INT: {
                if (context.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                    return Duration.ofSeconds(parser.getLongValue());
                }
                return Duration.ofMillis(parser.getLongValue());
            }
            case VALUE_STRING: {
                String string = parser.getText().trim();
                if (string.length() == 0) {
                    return null;
                }
                return Duration.parse(string);
            }
        }
        throw context.mappingException("Expected type float, integer, or string.");
    }
}

