/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.ConnectorPageSink;
import com.facebook.presto.jdbc.internal.spi.Page;
import com.facebook.presto.jdbc.internal.spi.RecordSink;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.type.BigintType;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class RecordPageSink
implements ConnectorPageSink {
    private final RecordSink recordSink;

    public RecordPageSink(RecordSink recordSink) {
        this.recordSink = Objects.requireNonNull(recordSink, "recordSink is null");
    }

    @Override
    public Collection<Slice> commit() {
        return this.recordSink.commit();
    }

    @Override
    public void rollback() {
        this.recordSink.rollback();
    }

    @Override
    public void appendPage(Page page, Block sampleWeightBlock) {
        Block[] blocks = page.getBlocks();
        List<Type> columnTypes = this.recordSink.getColumnTypes();
        for (int position = 0; position < page.getPositionCount(); ++position) {
            long sampleWeight = 1L;
            if (sampleWeightBlock != null) {
                sampleWeight = BigintType.BIGINT.getLong(sampleWeightBlock, position);
            }
            this.recordSink.beginRecord(sampleWeight);
            for (int i = 0; i < blocks.length; ++i) {
                this.writeField(position, blocks[i], columnTypes.get(i));
            }
            this.recordSink.finishRecord();
        }
    }

    private void writeField(int position, Block block, Type type) {
        if (block.isNull(position)) {
            this.recordSink.appendNull();
            return;
        }
        if (type.getJavaType() == Boolean.TYPE) {
            this.recordSink.appendBoolean(type.getBoolean(block, position));
        } else if (type.getJavaType() == Long.TYPE) {
            this.recordSink.appendLong(type.getLong(block, position));
        } else if (type.getJavaType() == Double.TYPE) {
            this.recordSink.appendDouble(type.getDouble(block, position));
        } else if (type.getJavaType() == Slice.class) {
            this.recordSink.appendString(type.getSlice(block, position).getBytes());
        } else {
            throw new AssertionError((Object)("unimplemented type: " + type));
        }
    }
}

