/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.block.FixedWidthBlockBuilder;
import com.facebook.presto.jdbc.internal.spi.type.AbstractType;
import com.facebook.presto.jdbc.internal.spi.type.FixedWidthType;
import com.facebook.presto.jdbc.internal.spi.type.TypeSignature;

public abstract class AbstractFixedWidthType
extends AbstractType
implements FixedWidthType {
    private final int fixedSize;

    protected AbstractFixedWidthType(TypeSignature signature, Class<?> javaType, int fixedSize) {
        super(signature, javaType);
        this.fixedSize = fixedSize;
    }

    @Override
    public final int getFixedSize() {
        return this.fixedSize;
    }

    @Override
    public final BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus) {
        return new FixedWidthBlockBuilder(this.getFixedSize(), blockBuilderStatus);
    }

    @Override
    public final BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new FixedWidthBlockBuilder(this.getFixedSize(), positionCount);
    }

    @Override
    public final Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, this.getFixedSize());
    }
}

