package com.facebook.presto.jdbc.internal.jackson.datatype.jdk8;

import java.io.IOException;
import java.util.OptionalDouble;

import com.facebook.presto.jdbc.internal.jackson.core.JsonGenerator;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonSerializer;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializerProvider;

final class OptionalDoubleSerializer extends JsonSerializer<OptionalDouble>
{
    static final OptionalDoubleSerializer INSTANCE = new OptionalDoubleSerializer();

    @Override
    public void serialize(OptionalDouble value, JsonGenerator jgen, SerializerProvider provider)
    throws IOException
    {
        if (value.isPresent()) {
            jgen.writeNumber(value.getAsDouble());
        } else {
            jgen.writeNull();
        }
    }
}
