/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client;

import com.facebook.presto.jdbc.internal.jetty.client.AsyncContentProvider;
import com.facebook.presto.jdbc.internal.jetty.client.HttpChannel;
import com.facebook.presto.jdbc.internal.jetty.client.HttpContent;
import com.facebook.presto.jdbc.internal.jetty.client.HttpConversation;
import com.facebook.presto.jdbc.internal.jetty.client.HttpDestination;
import com.facebook.presto.jdbc.internal.jetty.client.HttpExchange;
import com.facebook.presto.jdbc.internal.jetty.client.HttpRequest;
import com.facebook.presto.jdbc.internal.jetty.client.RequestNotifier;
import com.facebook.presto.jdbc.internal.jetty.client.api.ContentProvider;
import com.facebook.presto.jdbc.internal.jetty.client.api.Request;
import com.facebook.presto.jdbc.internal.jetty.client.api.Result;
import com.facebook.presto.jdbc.internal.jetty.http.HttpHeader;
import com.facebook.presto.jdbc.internal.jetty.http.HttpHeaderValue;
import com.facebook.presto.jdbc.internal.jetty.util.BufferUtil;
import com.facebook.presto.jdbc.internal.jetty.util.Callback;
import com.facebook.presto.jdbc.internal.jetty.util.IteratingCallback;
import com.facebook.presto.jdbc.internal.jetty.util.log.Log;
import com.facebook.presto.jdbc.internal.jetty.util.log.Logger;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;

public abstract class HttpSender
implements AsyncContentProvider.Listener {
    protected static final Logger LOG = Log.getLogger(HttpSender.class);
    private final AtomicReference<RequestState> requestState = new AtomicReference<RequestState>(RequestState.QUEUED);
    private final AtomicReference<SenderState> senderState = new AtomicReference<SenderState>(SenderState.IDLE);
    private final Callback commitCallback = new CommitCallback();
    private final IteratingCallback contentCallback = new ContentCallback();
    private final Callback lastCallback = new LastContentCallback();
    private final HttpChannel channel;
    private HttpContent content;
    private Throwable failure;

    protected HttpSender(HttpChannel channel) {
        this.channel = channel;
    }

    protected HttpChannel getHttpChannel() {
        return this.channel;
    }

    protected HttpExchange getHttpExchange() {
        return this.channel.getHttpExchange();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onContent() {
        exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        block7: while (true) {
            current = this.senderState.get();
            switch (1.$SwitchMap$org$eclipse$jetty$client$HttpSender$SenderState[current.ordinal()]) {
                case 1: {
                    newSenderState = SenderState.SENDING;
                    if (!this.updateSenderState(current, newSenderState)) continue block7;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Deferred content available, {} -> {}", new Object[]{current, newSenderState});
                    }
                    this.contentCallback.iterate();
                    return;
                }
                case 2: {
                    newSenderState = SenderState.SENDING_WITH_CONTENT;
                    if (!this.updateSenderState(current, newSenderState)) continue block7;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Deferred content available, {} -> {}", new Object[]{current, newSenderState});
                    }
                    return;
                }
                case 3: {
                    newSenderState = SenderState.EXPECTING_WITH_CONTENT;
                    if (!this.updateSenderState(current, newSenderState)) continue block7;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Deferred content available, {} -> {}", new Object[]{current, newSenderState});
                    }
                    return;
                }
                case 4: {
                    newSenderState = SenderState.PROCEEDING_WITH_CONTENT;
                    if (this.updateSenderState(current, newSenderState)) ** break;
                    continue block7;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Deferred content available, {} -> {}", new Object[]{current, newSenderState});
                    }
                    return;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Deferred content available, {}", new Object[]{current});
                    }
                    return;
                }
            }
            break;
        }
        throw this.illegalSenderState(current);
    }

    public void send(HttpExchange exchange) {
        HttpRequest request = exchange.getRequest();
        if (!this.queuedToBegin(request)) {
            return;
        }
        ContentProvider contentProvider = request.getContent();
        HttpContent content = this.content = new HttpContent(contentProvider);
        SenderState newSenderState = SenderState.SENDING;
        if (this.expects100Continue(request)) {
            SenderState senderState = newSenderState = content.hasContent() ? SenderState.EXPECTING_WITH_CONTENT : SenderState.EXPECTING;
        }
        if (!this.updateSenderState(SenderState.IDLE, newSenderState)) {
            throw this.illegalSenderState(SenderState.IDLE);
        }
        if (contentProvider instanceof AsyncContentProvider) {
            ((AsyncContentProvider)contentProvider).setListener(this);
        }
        if (!this.beginToHeaders(request)) {
            return;
        }
        this.sendHeaders(exchange, content, this.commitCallback);
    }

    protected boolean expects100Continue(Request request) {
        return request.getHeaders().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
    }

    protected boolean queuedToBegin(Request request) {
        if (!this.updateRequestState(RequestState.QUEUED, RequestState.TRANSIENT)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request begin {}", request);
        }
        RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        notifier.notifyBegin(request);
        if (!this.updateRequestState(RequestState.TRANSIENT, RequestState.BEGIN)) {
            this.terminateRequest(this.getHttpExchange(), this.failure);
        }
        return true;
    }

    protected boolean beginToHeaders(Request request) {
        if (!this.updateRequestState(RequestState.BEGIN, RequestState.TRANSIENT)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request headers {}{}{}", request, System.getProperty("line.separator"), request.getHeaders().toString().trim());
        }
        RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        notifier.notifyHeaders(request);
        if (!this.updateRequestState(RequestState.TRANSIENT, RequestState.HEADERS)) {
            this.terminateRequest(this.getHttpExchange(), this.failure);
        }
        return true;
    }

    protected boolean headersToCommit(Request request) {
        if (!this.updateRequestState(RequestState.HEADERS, RequestState.TRANSIENT)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request committed {}", request);
        }
        RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        notifier.notifyCommit(request);
        if (!this.updateRequestState(RequestState.TRANSIENT, RequestState.COMMIT)) {
            this.terminateRequest(this.getHttpExchange(), this.failure);
        }
        return true;
    }

    protected boolean someToContent(Request request, ByteBuffer content) {
        RequestState current = this.requestState.get();
        switch (current) {
            case COMMIT: 
            case CONTENT: {
                if (!this.updateRequestState(current, RequestState.TRANSIENT_CONTENT)) {
                    return false;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request content {}{}{}", request, System.getProperty("line.separator"), BufferUtil.toDetailString(content));
                }
                RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
                notifier.notifyContent(request, content);
                if (!this.updateRequestState(RequestState.TRANSIENT_CONTENT, RequestState.CONTENT)) {
                    this.terminateRequest(this.getHttpExchange(), this.failure);
                }
                return true;
            }
        }
        return false;
    }

    protected boolean someToSuccess(HttpExchange exchange) {
        RequestState current = this.requestState.get();
        switch (current) {
            case COMMIT: 
            case CONTENT: {
                boolean completed = exchange.requestComplete();
                if (!completed) {
                    return false;
                }
                this.requestState.set(RequestState.QUEUED);
                this.reset();
                Result result = exchange.terminateRequest(null);
                HttpRequest request = exchange.getRequest();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request success {}", request);
                }
                HttpDestination destination = this.getHttpChannel().getHttpDestination();
                destination.getRequestNotifier().notifySuccess(exchange.getRequest());
                this.terminateRequest(exchange, null, result);
                return true;
            }
        }
        return false;
    }

    protected boolean anyToFailure(Throwable failure) {
        RequestState current;
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        boolean completed = exchange.requestComplete();
        if (!completed) {
            return false;
        }
        this.failure = failure;
        while (!this.updateRequestState(current = this.requestState.get(), RequestState.FAILURE)) {
        }
        boolean fail = current != RequestState.TRANSIENT && current != RequestState.TRANSIENT_CONTENT;
        this.dispose();
        Result result = exchange.terminateRequest(failure);
        HttpRequest request = exchange.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request failure {} {}", exchange, failure);
        }
        HttpDestination destination = this.getHttpChannel().getHttpDestination();
        destination.getRequestNotifier().notifyFailure(request, failure);
        if (fail) {
            this.terminateRequest(exchange, failure, result);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Concurrent failure: request termination skipped, performed by helpers", new Object[0]);
        }
        return true;
    }

    private void terminateRequest(HttpExchange exchange, Throwable failure) {
        if (exchange != null) {
            Result result = exchange.terminateRequest(failure);
            this.terminateRequest(exchange, failure, result);
        }
    }

    private void terminateRequest(HttpExchange exchange, Throwable failure, Result result) {
        HttpRequest request = exchange.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Terminating request {}", request);
        }
        if (result == null) {
            if (failure != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response failure from request {}", exchange);
                }
                this.getHttpChannel().abortResponse(failure);
            }
        } else {
            HttpDestination destination = this.getHttpChannel().getHttpDestination();
            boolean ordered = destination.getHttpClient().isStrictEventOrdering();
            if (!ordered) {
                this.channel.exchangeTerminated(result);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request/Response {} {}", failure == null ? "succeeded" : "failed", request);
            }
            HttpConversation conversation = exchange.getConversation();
            destination.getResponseNotifier().notifyComplete(conversation.getResponseListeners(), result);
            if (ordered) {
                this.channel.exchangeTerminated(result);
            }
        }
    }

    protected abstract void sendHeaders(HttpExchange var1, HttpContent var2, Callback var3);

    protected abstract void sendContent(HttpExchange var1, HttpContent var2, Callback var3);

    protected void reset() {
        this.content.close();
        this.content = null;
        this.senderState.set(SenderState.IDLE);
    }

    protected void dispose() {
        HttpContent content = this.content;
        if (content != null) {
            content.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void proceed(HttpExchange exchange, Throwable failure) {
        if (!this.expects100Continue(exchange.getRequest())) {
            return;
        }
        if (failure != null) {
            this.anyToFailure(failure);
            return;
        }
        block5: while (true) {
            current = this.senderState.get();
            switch (1.$SwitchMap$org$eclipse$jetty$client$HttpSender$SenderState[current.ordinal()]) {
                case 3: {
                    if (!this.updateSenderState(current, SenderState.PROCEEDING)) continue block5;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Proceeding while expecting", new Object[0]);
                    }
                    return;
                }
                case 6: {
                    if (this.updateSenderState(current, SenderState.PROCEEDING_WITH_CONTENT)) ** break;
                    continue block5;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Proceeding while scheduled", new Object[0]);
                    }
                    return;
                }
                case 8: {
                    if (!this.updateSenderState(current, SenderState.SENDING)) {
                        throw this.illegalSenderState(current);
                    }
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Proceeding while waiting", new Object[0]);
                    }
                    this.contentCallback.iterate();
                    return;
                }
            }
            break;
        }
        throw this.illegalSenderState(current);
    }

    public boolean abort(Throwable failure) {
        RequestState current = this.requestState.get();
        boolean abortable = this.isBeforeCommit(current) || this.isSending(current);
        return abortable && this.anyToFailure(failure);
    }

    private boolean updateRequestState(RequestState from, RequestState to) {
        boolean updated = this.requestState.compareAndSet(from, to);
        if (!updated) {
            LOG.debug("RequestState update failed: {} -> {}: {}", new Object[]{from, to, this.requestState.get()});
        }
        return updated;
    }

    private boolean updateSenderState(SenderState from, SenderState to) {
        boolean updated = this.senderState.compareAndSet(from, to);
        if (!updated) {
            LOG.debug("SenderState update failed: {} -> {}: {}", new Object[]{from, to, this.senderState.get()});
        }
        return updated;
    }

    private boolean isBeforeCommit(RequestState requestState) {
        switch (requestState) {
            case TRANSIENT: 
            case QUEUED: 
            case BEGIN: 
            case HEADERS: {
                return true;
            }
        }
        return false;
    }

    private boolean isSending(RequestState requestState) {
        switch (requestState) {
            case COMMIT: 
            case CONTENT: 
            case TRANSIENT_CONTENT: {
                return true;
            }
        }
        return false;
    }

    private RuntimeException illegalSenderState(SenderState current) {
        return new IllegalStateException("Expected " + (Object)((Object)current) + " found " + (Object)((Object)this.senderState.get()) + " instead");
    }

    public String toString() {
        return String.format("%s@%x(req=%s,snd=%s)", this.getClass().getSimpleName(), this.hashCode(), this.requestState, this.senderState);
    }

    private class LastContentCallback
    implements Callback {
        private LastContentCallback() {
        }

        @Override
        public void succeeded() {
            HttpSender.this.content.succeeded();
            HttpExchange exchange = HttpSender.this.getHttpExchange();
            if (exchange == null) {
                return;
            }
            HttpSender.this.someToSuccess(exchange);
        }

        @Override
        public void failed(Throwable failure) {
            HttpSender.this.content.failed(failure);
            HttpSender.this.anyToFailure(failure);
        }
    }

    private class ContentCallback
    extends IteratingCallback {
        private ContentCallback() {
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            SenderState current;
            HttpExchange exchange = HttpSender.this.getHttpExchange();
            if (exchange == null) {
                return IteratingCallback.Action.IDLE;
            }
            HttpContent content = HttpSender.this.content;
            block4: while (true) {
                boolean advanced = content.advance();
                boolean consumed = content.isConsumed();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content {} consumed {} for {}", advanced, consumed, exchange.getRequest());
                }
                if (advanced) {
                    HttpSender.this.sendContent(exchange, content, this);
                    return IteratingCallback.Action.SCHEDULED;
                }
                if (consumed) {
                    HttpSender.this.sendContent(exchange, content, HttpSender.this.lastCallback);
                    return IteratingCallback.Action.IDLE;
                }
                current = (SenderState)((Object)HttpSender.this.senderState.get());
                switch (current) {
                    case SENDING: {
                        if (!HttpSender.this.updateSenderState(current, SenderState.IDLE)) continue block4;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Content is deferred for {}", exchange.getRequest());
                        }
                        return IteratingCallback.Action.IDLE;
                    }
                    case SENDING_WITH_CONTENT: {
                        HttpSender.this.updateSenderState(current, SenderState.SENDING);
                        continue block4;
                    }
                }
                break;
            }
            throw HttpSender.this.illegalSenderState(current);
        }

        @Override
        public void succeeded() {
            ByteBuffer buffer = HttpSender.this.content.getContent();
            HttpSender.this.someToContent(HttpSender.this.getHttpExchange().getRequest(), buffer);
            HttpSender.this.content.succeeded();
            super.succeeded();
        }

        @Override
        public void onCompleteFailure(Throwable failure) {
            HttpSender.this.content.failed(failure);
            HttpSender.this.anyToFailure(failure);
        }

        @Override
        protected void onCompleteSuccess() {
        }
    }

    private class CommitCallback
    implements Callback {
        private CommitCallback() {
        }

        @Override
        public void succeeded() {
            try {
                HttpSender.this.content.succeeded();
                this.process();
            }
            catch (Exception x) {
                HttpSender.this.anyToFailure(x);
            }
        }

        @Override
        public void failed(Throwable failure) {
            HttpSender.this.content.failed(failure);
            HttpSender.this.anyToFailure(failure);
        }

        private void process() throws Exception {
            HttpExchange exchange = HttpSender.this.getHttpExchange();
            if (exchange == null) {
                return;
            }
            HttpRequest request = exchange.getRequest();
            if (!HttpSender.this.headersToCommit(request)) {
                return;
            }
            HttpContent content = HttpSender.this.content;
            if (content.hasContent()) {
                SenderState current;
                ByteBuffer contentBuffer = content.getContent();
                if (contentBuffer != null && !HttpSender.this.someToContent(request, contentBuffer)) {
                    return;
                }
                block8: while (true) {
                    current = (SenderState)((Object)HttpSender.this.senderState.get());
                    switch (current) {
                        case SENDING: {
                            HttpSender.this.contentCallback.iterate();
                            return;
                        }
                        case SENDING_WITH_CONTENT: {
                            HttpSender.this.updateSenderState(current, SenderState.SENDING);
                            continue block8;
                        }
                        case EXPECTING: {
                            if (!HttpSender.this.updateSenderState(current, SenderState.WAITING)) continue block8;
                            return;
                        }
                        case EXPECTING_WITH_CONTENT: {
                            if (!HttpSender.this.updateSenderState(current, SenderState.WAITING)) continue block8;
                            return;
                        }
                        case PROCEEDING: {
                            if (!HttpSender.this.updateSenderState(current, SenderState.IDLE)) continue block8;
                            return;
                        }
                        case PROCEEDING_WITH_CONTENT: {
                            HttpSender.this.updateSenderState(current, SenderState.SENDING);
                            continue block8;
                        }
                    }
                    break;
                }
                throw HttpSender.this.illegalSenderState(current);
            }
            HttpSender.this.someToSuccess(exchange);
        }
    }

    private static enum SenderState {
        IDLE,
        SENDING,
        SENDING_WITH_CONTENT,
        EXPECTING,
        EXPECTING_WITH_CONTENT,
        WAITING,
        PROCEEDING,
        PROCEEDING_WITH_CONTENT;

    }

    private static enum RequestState {
        TRANSIENT,
        TRANSIENT_CONTENT,
        QUEUED,
        BEGIN,
        HEADERS,
        COMMIT,
        CONTENT,
        FAILURE;

    }
}

