/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client.http;

import com.facebook.presto.jdbc.internal.jetty.client.HttpConnection;
import com.facebook.presto.jdbc.internal.jetty.client.HttpDestination;
import com.facebook.presto.jdbc.internal.jetty.client.HttpExchange;
import com.facebook.presto.jdbc.internal.jetty.client.HttpRequest;
import com.facebook.presto.jdbc.internal.jetty.client.api.Connection;
import com.facebook.presto.jdbc.internal.jetty.client.api.Request;
import com.facebook.presto.jdbc.internal.jetty.client.api.Response;
import com.facebook.presto.jdbc.internal.jetty.client.http.HttpChannelOverHTTP;
import com.facebook.presto.jdbc.internal.jetty.client.http.HttpDestinationOverHTTP;
import com.facebook.presto.jdbc.internal.jetty.io.AbstractConnection;
import com.facebook.presto.jdbc.internal.jetty.io.EndPoint;
import com.facebook.presto.jdbc.internal.jetty.util.log.Log;
import com.facebook.presto.jdbc.internal.jetty.util.log.Logger;
import java.nio.channels.AsynchronousCloseException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class HttpConnectionOverHTTP
extends AbstractConnection
implements Connection {
    private static final Logger LOG = Log.getLogger(HttpConnectionOverHTTP.class);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Delegate delegate;
    private final HttpChannelOverHTTP channel;
    private long idleTimeout;

    public HttpConnectionOverHTTP(EndPoint endPoint, HttpDestination destination) {
        super(endPoint, destination.getHttpClient().getExecutor(), destination.getHttpClient().isDispatchIO());
        this.delegate = new Delegate(destination);
        this.channel = new HttpChannelOverHTTP(this);
    }

    public HttpChannelOverHTTP getHttpChannel() {
        return this.channel;
    }

    public HttpDestinationOverHTTP getHttpDestination() {
        return (HttpDestinationOverHTTP)this.delegate.getHttpDestination();
    }

    @Override
    public void send(Request request, Response.CompleteListener listener) {
        this.delegate.send(request, listener);
    }

    protected void send(HttpExchange exchange) {
        this.delegate.send(exchange);
    }

    @Override
    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    protected boolean onReadTimeout() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} idle timeout", this);
        }
        this.close(new TimeoutException());
        return false;
    }

    @Override
    public void onFillable() {
        HttpExchange exchange = this.channel.getHttpExchange();
        if (exchange != null) {
            this.channel.receive();
        } else {
            this.close();
        }
    }

    public void release() {
        this.getEndPoint().setIdleTimeout(this.idleTimeout);
        this.getHttpDestination().release(this);
    }

    @Override
    public void close() {
        this.close(new AsynchronousCloseException());
    }

    protected void close(Throwable failure) {
        if (this.softClose()) {
            this.getHttpDestination().close(this);
            this.getEndPoint().shutdownOutput();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} oshut", this);
            }
            this.getEndPoint().close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} closed", this);
            }
            this.abort(failure);
        }
    }

    public boolean softClose() {
        return this.closed.compareAndSet(false, true);
    }

    private boolean abort(Throwable failure) {
        HttpExchange exchange = this.channel.getHttpExchange();
        return exchange != null && exchange.getRequest().abort(failure);
    }

    @Override
    public String toString() {
        return String.format("%s@%h(l:%s <-> r:%s)[%s]", this.getClass().getSimpleName(), this, this.getEndPoint().getLocalAddress(), this.getEndPoint().getRemoteAddress(), this.channel);
    }

    private class Delegate
    extends HttpConnection {
        private Delegate(HttpDestination destination) {
            super(destination);
        }

        @Override
        protected void send(HttpExchange exchange) {
            HttpRequest request = exchange.getRequest();
            this.normalizeRequest(request);
            EndPoint endPoint = HttpConnectionOverHTTP.this.getEndPoint();
            HttpConnectionOverHTTP.this.idleTimeout = endPoint.getIdleTimeout();
            endPoint.setIdleTimeout(request.getIdleTimeout());
            HttpConnectionOverHTTP.this.channel.associate(exchange);
            HttpConnectionOverHTTP.this.channel.send();
        }

        @Override
        public void close() {
            HttpConnectionOverHTTP.this.close();
        }

        @Override
        public String toString() {
            return HttpConnectionOverHTTP.this.toString();
        }
    }
}

