/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.joda.deser;

import com.facebook.presto.jdbc.internal.jackson.core.JsonParser;
import com.facebook.presto.jdbc.internal.jackson.core.JsonProcessingException;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationContext;
import com.facebook.presto.jdbc.internal.jackson.databind.deser.std.StdScalarDeserializer;
import com.facebook.presto.jdbc.internal.joda.time.Duration;
import java.io.IOException;

public final class DurationDeserializer
extends StdScalarDeserializer<Duration> {
    private static final long serialVersionUID = 1L;

    public DurationDeserializer() {
        super(Duration.class);
    }

    @Override
    public Duration deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        switch (jsonParser.getCurrentToken()) {
            case VALUE_NUMBER_INT: {
                return new Duration(jsonParser.getLongValue());
            }
            case VALUE_STRING: {
                return new Duration(jsonParser.getText());
            }
        }
        throw deserializationContext.mappingException("expected JSON Number or String");
    }
}

