package com.facebook.presto.jdbc.internal.jackson.datatype.joda.ser;

import java.io.IOException;

import com.facebook.presto.jdbc.internal.joda.time.ReadablePeriod;
import com.facebook.presto.jdbc.internal.joda.time.format.ISOPeriodFormat;
import com.facebook.presto.jdbc.internal.joda.time.format.PeriodFormatter;

import com.facebook.presto.jdbc.internal.jackson.core.JsonGenerator;
import com.facebook.presto.jdbc.internal.jackson.core.JsonProcessingException;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonNode;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializerProvider;

/**
 * Serializes a {@link ReadablePeriod} using Joda default formatting.
 *<p>
 * TODO: allow serialization as an array of numbers, for numeric ("timestamp")
 * notation?
 */
public final class PeriodSerializer extends JodaSerializerBase<ReadablePeriod>
{
    protected final PeriodFormatter defaultFormat = ISOPeriodFormat.standard();

    public PeriodSerializer() { super(ReadablePeriod.class); }

    @Override
    public void serialize(ReadablePeriod value, JsonGenerator jgen, SerializerProvider provider) throws IOException,
        JsonProcessingException
    {
        jgen.writeString(defaultFormat.print(value));
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, java.lang.reflect.Type typeHint) {
        return createSchemaNode("string", true);
    }
}
