/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client.jetty;

import com.facebook.presto.jdbc.internal.airlift.http.client.jetty.JettyIoPoolConfig;
import com.facebook.presto.jdbc.internal.guava.base.MoreObjects;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.base.Throwables;
import com.facebook.presto.jdbc.internal.jetty.io.ByteBufferPool;
import com.facebook.presto.jdbc.internal.jetty.io.MappedByteBufferPool;
import com.facebook.presto.jdbc.internal.jetty.util.component.AbstractLifeCycle;
import com.facebook.presto.jdbc.internal.jetty.util.component.LifeCycle;
import com.facebook.presto.jdbc.internal.jetty.util.thread.QueuedThreadPool;
import com.facebook.presto.jdbc.internal.jetty.util.thread.Scheduler;
import java.io.Closeable;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class JettyIoPool
implements Closeable {
    private final String name;
    private final QueuedThreadPool executor;
    private final ByteBufferPool byteBufferPool;
    private final Scheduler scheduler;

    public JettyIoPool(String name, JettyIoPoolConfig config) {
        this.name = name;
        try {
            String baseName = "http-client-" + name;
            ThreadGroup threadGroup = new ThreadGroup(baseName);
            JettyThreadPool threadPool = new JettyThreadPool(threadGroup, config);
            threadPool.setName(baseName);
            threadPool.setDaemon(true);
            threadPool.start();
            threadPool.setStopTimeout(2000L);
            this.executor = threadPool;
            this.scheduler = new JettyScheduler(threadGroup, baseName + "-scheduler");
            this.scheduler.start();
            this.byteBufferPool = new MappedByteBufferPool();
        }
        catch (Exception e) {
            this.close();
            throw Throwables.propagate(e);
        }
    }

    @Override
    public void close() {
        try {
            JettyIoPool.closeQuietly(this.executor);
        }
        finally {
            JettyIoPool.closeQuietly(this.scheduler);
        }
    }

    private static void closeQuietly(LifeCycle service) {
        try {
            if (service != null) {
                service.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public ByteBufferPool setByteBufferPool() {
        return this.byteBufferPool;
    }

    public Scheduler setScheduler() {
        return this.scheduler;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).toString();
    }

    private static class JettyScheduler
    extends AbstractLifeCycle
    implements Scheduler {
        private final String name;
        private final ThreadGroup threadGroup;
        private volatile ScheduledThreadPoolExecutor scheduler;

        public JettyScheduler(ThreadGroup threadGroup, String name) {
            this.threadGroup = Preconditions.checkNotNull(threadGroup, "threadGroup is null");
            this.name = Preconditions.checkNotNull(name, "name is null");
        }

        @Override
        protected void doStart() throws Exception {
            this.scheduler = new ScheduledThreadPoolExecutor(1, runnable -> {
                Thread thread = new Thread(this.threadGroup, runnable);
                thread.setName(this.name + "-" + thread.getId());
                thread.setDaemon(true);
                return thread;
            });
            this.scheduler.setRemoveOnCancelPolicy(true);
            super.doStart();
        }

        @Override
        protected void doStop() throws Exception {
            this.scheduler.shutdownNow();
            super.doStop();
            this.scheduler = null;
        }

        @Override
        public Scheduler.Task schedule(Runnable task, long delay, TimeUnit unit) {
            return new ScheduledFutureTask(this.scheduler.schedule(task, delay, unit));
        }

        private class ScheduledFutureTask
        implements Scheduler.Task {
            private final ScheduledFuture<?> scheduledFuture;

            public ScheduledFutureTask(ScheduledFuture<?> scheduledFuture) {
                this.scheduledFuture = Preconditions.checkNotNull(scheduledFuture, "scheduledFuture is null");
            }

            @Override
            public boolean cancel() {
                return this.scheduledFuture.cancel(false);
            }
        }
    }

    private static class JettyThreadPool
    extends QueuedThreadPool {
        private final ThreadGroup threadGroup;

        private JettyThreadPool(ThreadGroup threadGroup, JettyIoPoolConfig config) {
            super(config.getMaxThreads(), config.getMinThreads());
            this.threadGroup = Preconditions.checkNotNull(threadGroup, "threadGroup is null");
        }

        @Override
        protected Thread newThread(Runnable runnable) {
            return new Thread(this.threadGroup, runnable);
        }
    }
}

