/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.joda.deser;

import com.facebook.presto.jdbc.internal.jackson.core.JsonParser;
import com.facebook.presto.jdbc.internal.jackson.core.JsonProcessingException;
import com.facebook.presto.jdbc.internal.jackson.core.JsonToken;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationContext;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonMappingException;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.deser.JodaDeserializerBase;
import com.facebook.presto.jdbc.internal.joda.time.Interval;
import java.io.IOException;

public class IntervalDeserializer
extends JodaDeserializerBase<Interval> {
    private static final long serialVersionUID = 5196071166239332742L;

    public IntervalDeserializer() {
        super(Interval.class);
    }

    @Override
    public Interval deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        long end;
        long start;
        int dashIndex;
        JsonToken t = jsonParser.getCurrentToken();
        if (t != JsonToken.VALUE_STRING) {
            throw deserializationContext.mappingException("expected JSON String, got " + (Object)((Object)t));
        }
        String v = jsonParser.getText().trim();
        int n = dashIndex = v.isEmpty() ? -1 : v.indexOf(45, 1);
        if (dashIndex < 0) {
            throw deserializationContext.weirdStringException(v, this.handledType(), "no hyphen found to separate start, end");
        }
        String str = v.substring(0, dashIndex);
        try {
            start = Long.valueOf(str);
            str = v.substring(dashIndex + 1);
            end = Long.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw JsonMappingException.from(jsonParser, "Failed to parse number from '" + str + "' (full source String '" + v + "') to construct " + this.handledType().getName());
        }
        return new Interval(start, end);
    }
}

