/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client;

import com.facebook.presto.jdbc.internal.jetty.client.HttpClient;
import com.facebook.presto.jdbc.internal.jetty.client.HttpDestination;
import com.facebook.presto.jdbc.internal.jetty.client.HttpExchange;
import com.facebook.presto.jdbc.internal.jetty.client.HttpRequest;
import com.facebook.presto.jdbc.internal.jetty.client.Origin;
import com.facebook.presto.jdbc.internal.jetty.client.api.Connection;
import com.facebook.presto.jdbc.internal.jetty.util.Promise;
import java.util.concurrent.atomic.AtomicReference;

public abstract class MultiplexHttpDestination<C extends Connection>
extends HttpDestination
implements Promise<Connection> {
    private final AtomicReference<ConnectState> connect = new AtomicReference<ConnectState>(ConnectState.DISCONNECTED);
    private C connection;

    protected MultiplexHttpDestination(HttpClient client, Origin origin) {
        super(client, origin);
    }

    @Override
    protected void send() {
        block5: while (true) {
            ConnectState current = this.connect.get();
            switch (current) {
                case DISCONNECTED: {
                    if (!this.connect.compareAndSet(current, ConnectState.CONNECTING)) continue block5;
                    this.newConnection(this);
                    return;
                }
                case CONNECTING: {
                    return;
                }
                case CONNECTED: {
                    if (this.process(this.connection, false)) continue block5;
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    @Override
    public void succeeded(Connection result) {
        this.connection = result;
        Connection connection = this.connection;
        if (this.connect.compareAndSet(ConnectState.CONNECTING, ConnectState.CONNECTED)) {
            this.process(connection, true);
        } else {
            connection.close();
            this.failed(new IllegalStateException());
        }
    }

    @Override
    public void failed(Throwable x) {
        this.connect.set(ConnectState.DISCONNECTED);
    }

    protected boolean process(C connection, boolean dispatch) {
        HttpClient client = this.getHttpClient();
        HttpExchange exchange = this.getHttpExchanges().poll();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing {} on {}", exchange, connection);
        }
        if (exchange == null) {
            return false;
        }
        HttpRequest request = exchange.getRequest();
        Throwable cause = request.getAbortCause();
        if (cause != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aborted before processing {}: {}", exchange, cause);
            }
            exchange.abort(cause);
        } else if (dispatch) {
            client.getExecutor().execute(new Runnable((Connection)connection, exchange){
                final /* synthetic */ Connection val$connection;
                final /* synthetic */ HttpExchange val$exchange;
                {
                    this.val$connection = connection;
                    this.val$exchange = httpExchange;
                }

                @Override
                public void run() {
                    MultiplexHttpDestination.this.send(this.val$connection, this.val$exchange);
                }
            });
        } else {
            this.send(connection, exchange);
        }
        return true;
    }

    @Override
    public void close() {
        super.close();
        C connection = this.connection;
        if (connection != null) {
            connection.close();
        }
    }

    @Override
    public void close(Connection connection) {
        block1: {
            ConnectState current;
            super.close(connection);
            while (!this.connect.compareAndSet(current = this.connect.get(), ConnectState.DISCONNECTED)) {
            }
            if (!this.getHttpClient().isRemoveIdleDestinations()) break block1;
            this.getHttpClient().removeDestination(this);
        }
    }

    protected abstract void send(C var1, HttpExchange var2);

    private static enum ConnectState {
        DISCONNECTED,
        CONNECTING,
        CONNECTED;

    }
}

