/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.spi.ErrorCode;
import com.facebook.presto.jdbc.internal.spi.ErrorCodeSupplier;

public enum StandardErrorCode implements ErrorCodeSupplier
{
    USER_ERROR(0),
    SYNTAX_ERROR(1),
    ABANDONED_QUERY(2),
    USER_CANCELED(3),
    PERMISSION_DENIED(4),
    NOT_FOUND(5),
    FUNCTION_NOT_FOUND(6),
    INVALID_FUNCTION_ARGUMENT(7),
    DIVISION_BY_ZERO(8),
    INVALID_CAST_ARGUMENT(9),
    OPERATOR_NOT_FOUND(10),
    INVALID_VIEW(11),
    ALREADY_EXISTS(12),
    NOT_SUPPORTED(13),
    INVALID_SESSION_PROPERTY(14),
    INVALID_WINDOW_FRAME(15),
    CONSTRAINT_VIOLATION(16),
    INTERNAL_ERROR(65536),
    TOO_MANY_REQUESTS_FAILED(65537),
    PAGE_TOO_LARGE(65538),
    PAGE_TRANSPORT_ERROR(65539),
    PAGE_TRANSPORT_TIMEOUT(65540),
    NO_NODES_AVAILABLE(65541),
    REMOTE_TASK_ERROR(65542),
    COMPILER_ERROR(65543),
    WORKER_RESTARTED(65544),
    INSUFFICIENT_RESOURCES(131072),
    EXCEEDED_MEMORY_LIMIT(131073),
    QUERY_QUEUE_FULL(131074),
    EXTERNAL(0x1000000);

    private final ErrorCode errorCode;

    private StandardErrorCode(int code) {
        this.errorCode = new ErrorCode(code, this.name());
    }

    @Override
    public ErrorCode toErrorCode() {
        return this.errorCode;
    }

    public static ErrorType toErrorType(int code) {
        if (code < INTERNAL_ERROR.toErrorCode().getCode()) {
            return ErrorType.USER_ERROR;
        }
        if (code < INSUFFICIENT_RESOURCES.toErrorCode().getCode()) {
            return ErrorType.INTERNAL_ERROR;
        }
        if (code < EXTERNAL.toErrorCode().getCode()) {
            return ErrorType.INSUFFICIENT_RESOURCES;
        }
        return ErrorType.EXTERNAL;
    }

    public static enum ErrorType {
        USER_ERROR,
        INTERNAL_ERROR,
        INSUFFICIENT_RESOURCES,
        EXTERNAL;

    }
}

