/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.guava.ser;

import com.facebook.presto.jdbc.internal.guava.collect.BoundType;
import com.facebook.presto.jdbc.internal.guava.collect.Range;
import com.facebook.presto.jdbc.internal.jackson.core.JsonGenerationException;
import com.facebook.presto.jdbc.internal.jackson.core.JsonGenerator;
import com.facebook.presto.jdbc.internal.jackson.core.JsonProcessingException;
import com.facebook.presto.jdbc.internal.jackson.databind.BeanProperty;
import com.facebook.presto.jdbc.internal.jackson.databind.JavaType;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonMappingException;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonSerializer;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializerProvider;
import com.facebook.presto.jdbc.internal.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.facebook.presto.jdbc.internal.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.facebook.presto.jdbc.internal.jackson.databind.jsontype.TypeSerializer;
import com.facebook.presto.jdbc.internal.jackson.databind.ser.ContextualSerializer;
import com.facebook.presto.jdbc.internal.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

public class RangeSerializer
extends StdSerializer<Range<?>>
implements ContextualSerializer {
    protected final JavaType _rangeType;
    protected final JsonSerializer<Object> _endpointSerializer;

    public RangeSerializer(JavaType type) {
        this(type, null);
    }

    public RangeSerializer(JavaType type, JsonSerializer<?> endpointSer) {
        super(type);
        this._rangeType = type;
        this._endpointSerializer = endpointSer;
    }

    @Override
    public boolean isEmpty(Range<?> value) {
        return super.isEmpty(value);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonSerializer<?> cs;
        if (this._endpointSerializer == null) {
            JavaType endpointType = this._rangeType.containedType(0);
            if (endpointType != null && !endpointType.hasRawClass(Object.class)) {
                JsonSerializer<Object> ser = prov.findValueSerializer(endpointType, property);
                return new RangeSerializer(this._rangeType, ser);
            }
        } else if (this._endpointSerializer instanceof ContextualSerializer && (cs = ((ContextualSerializer)((Object)this._endpointSerializer)).createContextual(prov, property)) != this._endpointSerializer) {
            return new RangeSerializer(this._rangeType, cs);
        }
        return this;
    }

    @Override
    public void serialize(Range<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartObject();
        this._writeContents(value, jgen, provider);
        jgen.writeEndObject();
    }

    @Override
    public void serializeWithType(Range<?> value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        typeSer.writeTypePrefixForObject(value, jgen);
        this._writeContents(value, jgen, provider);
        typeSer.writeTypeSuffixForObject(value, jgen);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonObjectFormatVisitor objectVisitor;
        if (visitor != null && (objectVisitor = visitor.expectObjectFormat(typeHint)) != null && this._endpointSerializer != null) {
            JavaType endpointType = this._rangeType.containedType(0);
            JavaType btType = visitor.getProvider().constructType((Type)((Object)BoundType.class));
            JsonSerializer<Object> btSer = visitor.getProvider().findValueSerializer(btType, null);
            objectVisitor.property("lowerEndpoint", this._endpointSerializer, endpointType);
            objectVisitor.property("lowerBoundType", btSer, btType);
            objectVisitor.property("upperEndpoint", this._endpointSerializer, endpointType);
            objectVisitor.property("upperBoundType", btSer, btType);
        }
    }

    private void _writeContents(Range<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value.hasLowerBound()) {
            if (this._endpointSerializer != null) {
                jgen.writeFieldName("lowerEndpoint");
                this._endpointSerializer.serialize(value.lowerEndpoint(), jgen, provider);
            } else {
                provider.defaultSerializeField("lowerEndpoint", value.lowerEndpoint(), jgen);
            }
            provider.defaultSerializeField("lowerBoundType", (Object)value.lowerBoundType(), jgen);
        }
        if (value.hasUpperBound()) {
            if (this._endpointSerializer != null) {
                jgen.writeFieldName("upperEndpoint");
                this._endpointSerializer.serialize(value.upperEndpoint(), jgen, provider);
            } else {
                provider.defaultSerializeField("upperEndpoint", value.upperEndpoint(), jgen);
            }
            provider.defaultSerializeField("upperBoundType", (Object)value.upperBoundType(), jgen);
        }
    }
}

