/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client.http;

import com.facebook.presto.jdbc.internal.jetty.client.HttpChannel;
import com.facebook.presto.jdbc.internal.jetty.client.HttpExchange;
import com.facebook.presto.jdbc.internal.jetty.client.api.Response;
import com.facebook.presto.jdbc.internal.jetty.client.api.Result;
import com.facebook.presto.jdbc.internal.jetty.client.http.HttpConnectionOverHTTP;
import com.facebook.presto.jdbc.internal.jetty.client.http.HttpReceiverOverHTTP;
import com.facebook.presto.jdbc.internal.jetty.client.http.HttpSenderOverHTTP;
import com.facebook.presto.jdbc.internal.jetty.http.HttpFields;
import com.facebook.presto.jdbc.internal.jetty.http.HttpHeader;
import com.facebook.presto.jdbc.internal.jetty.http.HttpHeaderValue;
import com.facebook.presto.jdbc.internal.jetty.http.HttpVersion;

public class HttpChannelOverHTTP
extends HttpChannel {
    private final HttpConnectionOverHTTP connection;
    private final HttpSenderOverHTTP sender;
    private final HttpReceiverOverHTTP receiver;

    public HttpChannelOverHTTP(HttpConnectionOverHTTP connection) {
        super(connection.getHttpDestination());
        this.connection = connection;
        this.sender = new HttpSenderOverHTTP(this);
        this.receiver = new HttpReceiverOverHTTP(this);
    }

    public HttpConnectionOverHTTP getHttpConnection() {
        return this.connection;
    }

    @Override
    public void send() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.sender.send(exchange);
        }
    }

    @Override
    public void proceed(HttpExchange exchange, Throwable failure) {
        this.sender.proceed(exchange, failure);
    }

    @Override
    public boolean abort(Throwable cause) {
        boolean sendAborted = this.sender.abort(cause);
        boolean receiveAborted = this.abortResponse(cause);
        return sendAborted || receiveAborted;
    }

    @Override
    public boolean abortResponse(Throwable cause) {
        return this.receiver.abort(cause);
    }

    public void receive() {
        this.receiver.receive();
    }

    @Override
    public void exchangeTerminated(Result result) {
        boolean close;
        super.exchangeTerminated(result);
        Response response = result.getResponse();
        HttpFields responseHeaders = response.getHeaders();
        boolean bl = close = result.isFailed() || this.receiver.isShutdown();
        if (!close) {
            close = response.getVersion().compareTo(HttpVersion.HTTP_1_1) < 0 ? !responseHeaders.contains(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.asString()) : responseHeaders.contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString());
        }
        if (close) {
            this.connection.close();
        } else {
            this.connection.release();
        }
    }

    @Override
    public String toString() {
        return String.format("%s@%x(send=%s,recv=%s)", this.getClass().getSimpleName(), this.hashCode(), this.sender, this.receiver);
    }
}

